/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.resources.ResponseCache;

public class ServerCodecs {
    protected final EncoderWrapper fullJsonEncoder;
    protected final EncoderWrapper compactJsonEncoder;
    protected final EncoderWrapper fullXmlEncoder;
    protected final EncoderWrapper compactXmlEncoder;

    protected ServerCodecs(EncoderWrapper fullJsonEncoder, EncoderWrapper compactJsonEncoder, EncoderWrapper fullXmlEncoder, EncoderWrapper compactXmlEncoder) {
        this.fullJsonEncoder = fullJsonEncoder;
        this.compactJsonEncoder = compactJsonEncoder;
        this.fullXmlEncoder = fullXmlEncoder;
        this.compactXmlEncoder = compactXmlEncoder;
    }

    public EncoderWrapper getEncoder(ResponseCache.KeyType keyType, boolean compact) {
        switch (keyType) {
            case JSON: {
                return compact ? this.compactJsonEncoder : this.fullJsonEncoder;
            }
        }
        return compact ? this.compactXmlEncoder : this.fullXmlEncoder;
    }

    public EncoderWrapper getEncoder(ResponseCache.KeyType keyType, EurekaAccept eurekaAccept) {
        switch (eurekaAccept) {
            case compact: {
                return this.getEncoder(keyType, true);
            }
        }
        return this.getEncoder(keyType, false);
    }

    public static class Builder {
        private EncoderWrapper fullJsonEncoder;
        private EncoderWrapper compactJsonEncoder;
        private EncoderWrapper fullXmlEncoder;
        private EncoderWrapper compactXmlEncoder;

        public Builder withFullJsonEncoder(EncoderWrapper fullJsonEncoder) {
            this.fullJsonEncoder = fullJsonEncoder;
            return this;
        }

        public Builder withCompactJsonEncoder(EncoderWrapper compactJsonEncoder) {
            this.compactJsonEncoder = compactJsonEncoder;
            return this;
        }

        public Builder withFullXmlnEncoder(EncoderWrapper fullXmlEncoder) {
            this.fullXmlEncoder = fullXmlEncoder;
            return this;
        }

        public Builder withCompactXmlEncoder(EncoderWrapper compactXmlEncoder) {
            this.compactXmlEncoder = compactXmlEncoder;
            return this;
        }

        public Builder withEurekaServerConfig(EurekaServerConfig config) {
            this.fullJsonEncoder = CodecWrappers.getEncoder((String)config.getJsonCodecName());
            this.fullXmlEncoder = CodecWrappers.getEncoder((String)config.getXmlCodecName());
            return this;
        }

        public ServerCodecs build() {
            if (this.fullJsonEncoder == null) {
                this.fullJsonEncoder = CodecWrappers.getEncoder(CodecWrappers.LegacyJacksonJson.class);
            }
            if (this.compactJsonEncoder == null) {
                this.compactJsonEncoder = CodecWrappers.getEncoder(CodecWrappers.JacksonJsonMini.class);
            }
            if (this.fullXmlEncoder == null) {
                this.fullXmlEncoder = CodecWrappers.getEncoder(CodecWrappers.XStreamXml.class);
            }
            if (this.compactXmlEncoder == null) {
                this.compactXmlEncoder = CodecWrappers.getEncoder(CodecWrappers.JacksonXmlMini.class);
            }
            return new ServerCodecs(this.fullJsonEncoder, this.compactJsonEncoder, this.fullXmlEncoder, this.compactXmlEncoder);
        }
    }
}

