/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.EurekaHttpClient;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.cluster.AsgReplicationTask;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.InstanceReplicationTask;
import com.netflix.eureka.cluster.ReplicationTask;
import com.netflix.eureka.cluster.ReplicationTaskProcessor;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.eureka.util.batcher.TaskDispatcher;
import com.netflix.eureka.util.batcher.TaskDispatchers;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerEurekaNode {
    private static final long RETRY_SLEEP_TIME_MS = 100L;
    private static final long SERVER_UNAVAILABLE_SLEEP_TIME_MS = 1000L;
    private static final long MAX_BATCHING_DELAY_MS = 500L;
    private static final int BATCH_SIZE = 250;
    private static final Logger logger = LoggerFactory.getLogger(PeerEurekaNode.class);
    public static final String BATCH_URL_PATH = "peerreplication/batch/";
    public static final String HEADER_REPLICATION = "x-netflix-discovery-replication";
    private final String serviceUrl;
    private final EurekaServerConfig config;
    private final long maxProcessingDelayMs;
    private final PeerAwareInstanceRegistry registry;
    private final String targetHost;
    private final HttpReplicationClient replicationClient;
    private final TaskDispatcher<String, ReplicationTask> batchingDispatcher;
    private final TaskDispatcher<String, ReplicationTask> nonBatchingDispatcher;

    public PeerEurekaNode(PeerAwareInstanceRegistry registry, String targetHost, String serviceUrl, HttpReplicationClient replicationClient, EurekaServerConfig config) {
        this(registry, targetHost, serviceUrl, replicationClient, config, 250, 500L, 100L, 1000L);
    }

    PeerEurekaNode(PeerAwareInstanceRegistry registry, String targetHost, String serviceUrl, HttpReplicationClient replicationClient, EurekaServerConfig config, int batchSize, long maxBatchingDelayMs, long retrySleepTimeMs, long serverUnavailableSleepTimeMs) {
        this.registry = registry;
        this.targetHost = targetHost;
        this.replicationClient = replicationClient;
        this.serviceUrl = serviceUrl;
        this.config = config;
        this.maxProcessingDelayMs = config.getMaxTimeForReplication();
        String batcherName = this.getBatcherName();
        ReplicationTaskProcessor taskProcessor = new ReplicationTaskProcessor(targetHost, replicationClient);
        this.batchingDispatcher = TaskDispatchers.createBatchingTaskDispatcher(batcherName, config.getMaxElementsInPeerReplicationPool(), batchSize, config.getMaxThreadsForPeerReplication(), maxBatchingDelayMs, serverUnavailableSleepTimeMs, retrySleepTimeMs, taskProcessor);
        this.nonBatchingDispatcher = TaskDispatchers.createNonBatchingTaskDispatcher(targetHost, config.getMaxElementsInStatusReplicationPool(), config.getMaxThreadsForStatusReplication(), maxBatchingDelayMs, serverUnavailableSleepTimeMs, retrySleepTimeMs, taskProcessor);
    }

    public void register(final InstanceInfo info) throws Exception {
        long expiryTime = System.currentTimeMillis() + (long)PeerEurekaNode.getLeaseRenewalOf(info);
        this.batchingDispatcher.process(PeerEurekaNode.taskId("register", info), new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.Register, info, null, true){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.register(info);
            }
        }, expiryTime);
    }

    public void cancel(final String appName, final String id) throws Exception {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.batchingDispatcher.process(PeerEurekaNode.taskId("cancel", appName, id), new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.Cancel, appName, id){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.cancel(appName, id);
            }

            @Override
            public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
                super.handleFailure(statusCode, responseEntity);
                if (statusCode == 404) {
                    logger.warn("{}: missing entry.", (Object)this.getTaskName());
                }
            }
        }, expiryTime);
    }

    public void heartbeat(final String appName, final String id, final InstanceInfo info, final InstanceInfo.InstanceStatus overriddenStatus, boolean primeConnection) throws Throwable {
        if (primeConnection) {
            this.replicationClient.sendHeartBeat(appName, id, info, overriddenStatus);
            return;
        }
        InstanceReplicationTask replicationTask = new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.Heartbeat, info, overriddenStatus, false){

            public EurekaHttpClient.HttpResponse<InstanceInfo> execute() throws Throwable {
                return PeerEurekaNode.this.replicationClient.sendHeartBeat(appName, id, info, overriddenStatus);
            }

            @Override
            public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
                InstanceInfo peerInstanceInfo;
                super.handleFailure(statusCode, responseEntity);
                if (statusCode == 404) {
                    logger.warn("{}: missing entry.", (Object)this.getTaskName());
                    if (info != null) {
                        logger.warn("{}: cannot find instance id {} and hence replicating the instance with status {}", new Object[]{this.getTaskName(), info.getId(), info.getStatus()});
                        PeerEurekaNode.this.register(info);
                    }
                } else if (PeerEurekaNode.this.config.shouldSyncWhenTimestampDiffers() && (peerInstanceInfo = (InstanceInfo)responseEntity) != null) {
                    PeerEurekaNode.this.syncInstancesIfTimestampDiffers(appName, id, info, peerInstanceInfo);
                }
            }
        };
        long expiryTime = System.currentTimeMillis() + (long)PeerEurekaNode.getLeaseRenewalOf(info);
        this.batchingDispatcher.process(PeerEurekaNode.taskId("heartbeat", info), replicationTask, expiryTime);
    }

    public void statusUpdate(final String asgName, final ASGResource.ASGStatus newStatus) {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.nonBatchingDispatcher.process(asgName, new AsgReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.StatusUpdate, asgName, newStatus){

            @Override
            public EurekaHttpClient.HttpResponse<?> execute() {
                return PeerEurekaNode.this.replicationClient.statusUpdate(asgName, newStatus);
            }
        }, expiryTime);
    }

    public void statusUpdate(final String appName, final String id, final InstanceInfo.InstanceStatus newStatus, final InstanceInfo info) {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.batchingDispatcher.process(PeerEurekaNode.taskId("statusUpdate", appName, id), new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.StatusUpdate, info, null, false){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.statusUpdate(appName, id, newStatus, info);
            }
        }, expiryTime);
    }

    public void deleteStatusOverride(final String appName, final String id, final InstanceInfo info) {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.batchingDispatcher.process(PeerEurekaNode.taskId("deleteStatusOverride", appName, id), new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.DeleteStatusOverride, info, null, false){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.deleteStatusOverride(appName, id, info);
            }
        }, expiryTime);
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerEurekaNode other = (PeerEurekaNode)obj;
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }

    public void shutDown() {
        this.batchingDispatcher.shutdown();
        this.nonBatchingDispatcher.shutdown();
    }

    private void syncInstancesIfTimestampDiffers(String appName, String id, InstanceInfo info, InstanceInfo infoFromPeer) {
        try {
            if (infoFromPeer != null) {
                logger.warn("Peer wants us to take the instance information from it, since the timestamp differs,Id : {} My Timestamp : {}, Peer's timestamp: {}", new Object[]{id, info.getLastDirtyTimestamp(), infoFromPeer.getLastDirtyTimestamp()});
                if (infoFromPeer.getOverriddenStatus() != null && !InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)infoFromPeer.getOverriddenStatus())) {
                    logger.warn("Overridden Status info -id {}, mine {}, peer's {}", new Object[]{id, info.getOverriddenStatus(), infoFromPeer.getOverriddenStatus()});
                    this.registry.storeOverriddenStatusIfRequired(appName, id, infoFromPeer.getOverriddenStatus());
                }
                this.registry.register(infoFromPeer, true);
            }
        }
        catch (Throwable e) {
            logger.warn("Exception when trying to set information from peer :", e);
        }
    }

    public String getBatcherName() {
        String batcherName;
        try {
            batcherName = new URL(this.serviceUrl).getHost();
        }
        catch (MalformedURLException e1) {
            batcherName = this.serviceUrl;
        }
        return "target_" + batcherName;
    }

    private static String taskId(String requestType, String appName, String id) {
        return requestType + '#' + appName + '/' + id;
    }

    private static String taskId(String requestType, InstanceInfo info) {
        return PeerEurekaNode.taskId(requestType, info.getAppName(), info.getId());
    }

    private static int getLeaseRenewalOf(InstanceInfo info) {
        return (info.getLeaseInfo() == null ? 90 : info.getLeaseInfo().getRenewalIntervalInSecs()) * 1000;
    }
}

