/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.Version;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.ResponseCache;
import com.netflix.eureka.resources.CurrentRequestVersion;
import com.netflix.eureka.resources.InstanceResource;
import com.netflix.eureka.util.EurekaMonitors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
public class ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationResource.class);
    private final String appName;
    private final EurekaServerConfig serverConfig;
    private final PeerAwareInstanceRegistry registry;
    private final ResponseCache responseCache;

    ApplicationResource(String appName, EurekaServerConfig serverConfig, PeerAwareInstanceRegistry registry) {
        this.appName = appName.toUpperCase();
        this.serverConfig = serverConfig;
        this.registry = registry;
        this.responseCache = registry.getResponseCache();
    }

    public String getAppName() {
        return this.appName;
    }

    @GET
    public Response getApplication(@PathParam(value="version") String version, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="X-Eureka-Accept") String eurekaAccept) {
        Key cacheKey;
        String payLoad;
        if (!this.registry.shouldAllowAccess(false)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        EurekaMonitors.GET_APPLICATION.increment();
        CurrentRequestVersion.set(Version.toEnum(version));
        Key.KeyType keyType = Key.KeyType.JSON;
        if (acceptHeader == null || !acceptHeader.contains("json")) {
            keyType = Key.KeyType.XML;
        }
        if ((payLoad = this.responseCache.get(cacheKey = new Key(Key.EntityType.Application, this.appName, keyType, CurrentRequestVersion.get(), EurekaAccept.fromString((String)eurekaAccept)))) != null) {
            logger.debug("Found: {}", (Object)this.appName);
            return Response.ok((Object)payLoad).build();
        }
        logger.debug("Not Found: {}", (Object)this.appName);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="{id}")
    public InstanceResource getInstanceInfo(@PathParam(value="id") String id) {
        return new InstanceResource(this, id, this.serverConfig, this.registry);
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response addInstance(InstanceInfo info, @HeaderParam(value="x-netflix-discovery-replication") String isReplication) {
        logger.debug("Registering instance {} (replication={})", (Object)info.getId(), (Object)isReplication);
        if (this.isBlank(info.getId())) {
            return Response.status((int)400).entity((Object)"Missing instanceId").build();
        }
        if (this.isBlank(info.getHostName())) {
            return Response.status((int)400).entity((Object)"Missing hostname").build();
        }
        if (this.isBlank(info.getAppName())) {
            return Response.status((int)400).entity((Object)"Missing appName").build();
        }
        if (!this.appName.equals(info.getAppName())) {
            return Response.status((int)400).entity((Object)("Mismatched appName, expecting " + this.appName + " but was " + info.getAppName())).build();
        }
        this.registry.register(info, "true".equals(isReplication));
        return Response.status((int)204).build();
    }

    String getName() {
        return this.appName;
    }

    private boolean isBlank(String str) {
        return str == null || str.isEmpty();
    }
}

