/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.provider.Serializer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="status")
public class StatusInfo {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    private Map<String, String> generalStats = new HashMap<String, String>();
    private Map<String, String> applicationStats;
    private InstanceInfo instanceInfo;
    private Boolean isHeathly;

    private StatusInfo() {
    }

    public InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    public boolean isHealthy() {
        return this.isHeathly;
    }

    public Map<String, String> getGeneralStats() {
        return this.generalStats;
    }

    public Map<String, String> getApplicationStats() {
        return this.applicationStats;
    }

    public static String getUpTime() {
        long diff = ManagementFactory.getRuntimeMXBean().getUptime();
        long minutes = (diff /= 60000L) % 60L;
        long hours = (diff /= 60L) % 24L;
        long days = diff /= 24L;
        StringBuilder buf = new StringBuilder();
        if (days == 1L) {
            buf.append("1 day ");
        } else if (days > 1L) {
            buf.append(Long.valueOf(days).toString()).append(" days ");
        }
        DecimalFormat format = new DecimalFormat();
        format.setMinimumIntegerDigits(2);
        buf.append(format.format(hours)).append(":").append(format.format(minutes));
        return buf.toString();
    }

    public static String getCurrentTimeAsString() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(new Date());
    }

    public static final class Builder {
        @XStreamOmitField
        private StatusInfo result = new StatusInfo();

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder isHealthy(boolean b) {
            this.result.isHeathly = b;
            return this;
        }

        public Builder withInstanceInfo(InstanceInfo instanceInfo) {
            this.result.instanceInfo = instanceInfo;
            return this;
        }

        public Builder add(String key, String value) {
            if (this.result.applicationStats == null) {
                this.result.applicationStats = new HashMap();
            }
            this.result.applicationStats.put(key, value);
            return this;
        }

        public StatusInfo build() {
            if (this.result.instanceInfo == null) {
                throw new IllegalStateException("instanceInfo can not be null");
            }
            this.result.generalStats.put("server-uptime", StatusInfo.getUpTime());
            this.result.generalStats.put("environment", ConfigurationManager.getDeploymentContext().getDeploymentEnvironment());
            Runtime runtime = Runtime.getRuntime();
            int totalMem = (int)(runtime.totalMemory() / 0x100000L);
            int freeMem = (int)(runtime.freeMemory() / 0x100000L);
            int usedPercent = (int)((double)(((float)totalMem - (float)freeMem) / (float)totalMem) * 100.0);
            this.result.generalStats.put("num-of-cpus", String.valueOf(runtime.availableProcessors()));
            this.result.generalStats.put("total-avail-memory", String.valueOf(totalMem) + "mb");
            this.result.generalStats.put("current-memory-usage", String.valueOf(totalMem - freeMem) + "mb (" + usedPercent + "%)");
            return this.result;
        }
    }
}

