/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRequestCache {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestCache.class);
    private static final ConcurrentHashMap<RequestCacheKey, HystrixRequestCache> caches = new ConcurrentHashMap();
    private final RequestCacheKey rcKey;
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private static final HystrixRequestVariableHolder<ConcurrentHashMap<ValueCacheKey, Future<?>>> requestVariableForCache = new HystrixRequestVariableHolder(new HystrixRequestVariableLifecycle<ConcurrentHashMap<ValueCacheKey, Future<?>>>(){

        @Override
        public ConcurrentHashMap<ValueCacheKey, Future<?>> initialValue() {
            return new ConcurrentHashMap();
        }

        @Override
        public void shutdown(ConcurrentHashMap<ValueCacheKey, Future<?>> value) {
        }
    });

    private HystrixRequestCache(RequestCacheKey rcKey, HystrixConcurrencyStrategy concurrencyStrategy) {
        this.rcKey = rcKey;
        this.concurrencyStrategy = concurrencyStrategy;
    }

    public static HystrixRequestCache getInstance(HystrixCommandKey key, HystrixConcurrencyStrategy concurrencyStrategy) {
        return HystrixRequestCache.getInstance(new RequestCacheKey(key, concurrencyStrategy), concurrencyStrategy);
    }

    public static HystrixRequestCache getInstance(HystrixCollapserKey key, HystrixConcurrencyStrategy concurrencyStrategy) {
        return HystrixRequestCache.getInstance(new RequestCacheKey(key, concurrencyStrategy), concurrencyStrategy);
    }

    private static HystrixRequestCache getInstance(RequestCacheKey rcKey, HystrixConcurrencyStrategy concurrencyStrategy) {
        HystrixRequestCache c = caches.get(rcKey);
        if (c == null) {
            HystrixRequestCache newRequestCache = new HystrixRequestCache(rcKey, concurrencyStrategy);
            HystrixRequestCache existing = caches.putIfAbsent(rcKey, newRequestCache);
            c = existing == null ? newRequestCache : existing;
        }
        return c;
    }

    public <T> Future<T> get(String cacheKey) {
        ValueCacheKey key = this.getRequestCacheKey(cacheKey);
        if (key != null) {
            return requestVariableForCache.get(this.concurrencyStrategy).get(key);
        }
        return null;
    }

    public <T> Future<T> putIfAbsent(String cacheKey, Future<T> f) {
        Future<T> alreadySet;
        ValueCacheKey key = this.getRequestCacheKey(cacheKey);
        if (key != null && (alreadySet = requestVariableForCache.get(this.concurrencyStrategy).putIfAbsent(key, f)) != null) {
            return alreadySet;
        }
        return null;
    }

    public void clear(String cacheKey) {
        ValueCacheKey key = this.getRequestCacheKey(cacheKey);
        if (key != null) {
            requestVariableForCache.get(this.concurrencyStrategy).remove(key);
        }
    }

    private ValueCacheKey getRequestCacheKey(String cacheKey) {
        if (cacheKey != null) {
            return new ValueCacheKey(this.rcKey, cacheKey);
        }
        return null;
    }

    public static class UnitTest {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testCache() {
            HystrixConcurrencyStrategy strategy = HystrixConcurrencyStrategyDefault.getInstance();
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                HystrixRequestCache cache1 = HystrixRequestCache.getInstance(HystrixCommandKey.Factory.asKey("command1"), strategy);
                cache1.putIfAbsent("valueA", new TestFuture("a1"));
                cache1.putIfAbsent("valueA", new TestFuture("a2"));
                cache1.putIfAbsent("valueB", new TestFuture("b1"));
                HystrixRequestCache cache2 = HystrixRequestCache.getInstance(HystrixCommandKey.Factory.asKey("command2"), strategy);
                cache2.putIfAbsent("valueA", new TestFuture("a3"));
                Assert.assertEquals((Object)"a1", cache1.get("valueA").get());
                Assert.assertEquals((Object)"b1", cache1.get("valueB").get());
                Assert.assertEquals((Object)"a3", cache2.get("valueA").get());
                Assert.assertNull(cache2.get("valueB"));
            }
            catch (Exception e) {
                Assert.fail((String)("Exception: " + e.getMessage()));
                e.printStackTrace();
            }
            finally {
                context.shutdown();
            }
            context = HystrixRequestContext.initializeContext();
            try {
                HystrixRequestCache cache = HystrixRequestCache.getInstance(HystrixCommandKey.Factory.asKey("command1"), strategy);
                Assert.assertNull(cache.get("valueA"));
                Assert.assertNull(cache.get("valueB"));
            }
            finally {
                context.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testClearCache() {
            HystrixConcurrencyStrategy strategy = HystrixConcurrencyStrategyDefault.getInstance();
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                HystrixRequestCache cache1 = HystrixRequestCache.getInstance(HystrixCommandKey.Factory.asKey("command1"), strategy);
                cache1.putIfAbsent("valueA", new TestFuture("a1"));
                Assert.assertEquals((Object)"a1", cache1.get("valueA").get());
                cache1.clear("valueA");
                Assert.assertNull(cache1.get("valueA"));
            }
            catch (Exception e) {
                Assert.fail((String)("Exception: " + e.getMessage()));
                e.printStackTrace();
            }
            finally {
                context.shutdown();
            }
        }

        private static class TestFuture
        implements Future<String> {
            private final String value;

            public TestFuture(String value) {
                this.value = value;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public String get() throws InterruptedException, ExecutionException {
                return this.value;
            }

            @Override
            public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.value;
            }
        }
    }

    private static class RequestCacheKey {
        private final short type;
        private final String key;
        private final HystrixConcurrencyStrategy concurrencyStrategy;

        private RequestCacheKey(HystrixCommandKey commandKey, HystrixConcurrencyStrategy concurrencyStrategy) {
            this.type = 1;
            this.key = commandKey == null ? null : commandKey.name();
            this.concurrencyStrategy = concurrencyStrategy;
        }

        private RequestCacheKey(HystrixCollapserKey collapserKey, HystrixConcurrencyStrategy concurrencyStrategy) {
            this.type = (short)2;
            this.key = collapserKey == null ? null : collapserKey.name();
            this.concurrencyStrategy = concurrencyStrategy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.concurrencyStrategy == null ? 0 : this.concurrencyStrategy.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequestCacheKey other = (RequestCacheKey)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.concurrencyStrategy == null ? other.concurrencyStrategy != null : !this.concurrencyStrategy.equals(other.concurrencyStrategy));
        }
    }

    private static class ValueCacheKey {
        private final RequestCacheKey rvKey;
        private final String valueCacheKey;

        private ValueCacheKey(RequestCacheKey rvKey, String valueCacheKey) {
            this.rvKey = rvKey;
            this.valueCacheKey = valueCacheKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rvKey == null ? 0 : this.rvKey.hashCode());
            result = 31 * result + (this.valueCacheKey == null ? 0 : this.valueCacheKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueCacheKey other = (ValueCacheKey)obj;
            if (this.rvKey == null ? other.rvKey != null : !this.rvKey.equals(other.rvKey)) {
                return false;
            }
            return !(this.valueCacheKey == null ? other.valueCacheKey != null : !this.valueCacheKey.equals(other.valueCacheKey));
        }
    }
}

