/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.util.concurrent.Callable;

public class HystrixContextCallable<K>
implements Callable<K> {
    private final Callable<K> actual;
    private final HystrixRequestContext parentThreadState;

    public HystrixContextCallable(Callable<K> actual) {
        this.actual = actual;
        this.parentThreadState = HystrixRequestContext.getContextForCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K call() throws Exception {
        HystrixRequestContext existingState = HystrixRequestContext.getContextForCurrentThread();
        try {
            HystrixRequestContext.setContextOnCurrentThread(this.parentThreadState);
            K k = this.actual.call();
            return k;
        }
        finally {
            HystrixRequestContext.setContextOnCurrentThread(existingState);
        }
    }
}

