/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixTimer {
    private static final Logger logger = LoggerFactory.getLogger(HystrixTimer.class);
    private static HystrixTimer INSTANCE = new HystrixTimer();
    private AtomicReference<ScheduledExecutor> executor = new AtomicReference();

    private HystrixTimer() {
    }

    public static HystrixTimer getInstance() {
        return INSTANCE;
    }

    public static void reset() {
        ScheduledExecutor ex = HystrixTimer.INSTANCE.executor.getAndSet(null);
        if (ex != null && ex.getThreadPool() != null) {
            ex.getThreadPool().shutdownNow();
        }
    }

    public Reference<TimerListener> addTimerListener(final TimerListener listener) {
        this.startThreadIfNeeded();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    listener.tick();
                }
                catch (Exception e) {
                    logger.error("Failed while ticking TimerListener", (Throwable)e);
                }
            }
        };
        ScheduledFuture<?> f = this.executor.get().getThreadPool().scheduleAtFixedRate(r, listener.getIntervalTimeInMilliseconds(), listener.getIntervalTimeInMilliseconds(), TimeUnit.MILLISECONDS);
        return new TimerReference(listener, f);
    }

    protected void startThreadIfNeeded() {
        while (this.executor.get() == null || !this.executor.get().isInitialized()) {
            if (!this.executor.compareAndSet(null, new ScheduledExecutor())) continue;
            this.executor.get().initialize();
        }
    }

    public static class UnitTest {
        @Test
        public void testSingleCommandSingleInterval() {
            HystrixTimer timer = HystrixTimer.getInstance();
            TestListener l1 = new TestListener(50, "A");
            timer.addTimerListener(l1);
            TestListener l2 = new TestListener(50, "B");
            timer.addTimerListener(l2);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("l1 ticks: " + l1.tickCount.get());
            System.out.println("l2 ticks: " + l2.tickCount.get());
            Assert.assertTrue((l1.tickCount.get() > 7 ? 1 : 0) != 0);
            Assert.assertTrue((l2.tickCount.get() > 7 ? 1 : 0) != 0);
        }

        @Test
        public void testSingleCommandMultipleIntervals() {
            HystrixTimer timer = HystrixTimer.getInstance();
            TestListener l1 = new TestListener(100, "A");
            timer.addTimerListener(l1);
            TestListener l2 = new TestListener(10, "B");
            timer.addTimerListener(l2);
            TestListener l3 = new TestListener(25, "C");
            timer.addTimerListener(l3);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("l1 ticks: " + l1.tickCount.get());
            Assert.assertTrue((l1.tickCount.get() >= 3 ? 1 : 0) != 0);
            Assert.assertTrue((l1.tickCount.get() < 6 ? 1 : 0) != 0);
            System.out.println("l2 ticks: " + l2.tickCount.get());
            Assert.assertTrue((l2.tickCount.get() > 30 ? 1 : 0) != 0);
            Assert.assertTrue((l2.tickCount.get() < 550 ? 1 : 0) != 0);
            System.out.println("l3 ticks: " + l3.tickCount.get());
            Assert.assertTrue((l3.tickCount.get() > 14 ? 1 : 0) != 0);
            Assert.assertTrue((l3.tickCount.get() < 25 ? 1 : 0) != 0);
        }

        @Test
        public void testSingleCommandRemoveListener() {
            HystrixTimer timer = HystrixTimer.getInstance();
            TestListener l1 = new TestListener(50, "A");
            timer.addTimerListener(l1);
            TestListener l2 = new TestListener(50, "B");
            Reference<TimerListener> l2ref = timer.addTimerListener(l2);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("l1 ticks: " + l1.tickCount.get());
            System.out.println("l2 ticks: " + l2.tickCount.get());
            Assert.assertTrue((l1.tickCount.get() > 7 ? 1 : 0) != 0);
            Assert.assertTrue((l2.tickCount.get() > 7 ? 1 : 0) != 0);
            l2ref.clear();
            l1.tickCount.set(0);
            l2.tickCount.set(0);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("l1 ticks: " + l1.tickCount.get());
            System.out.println("l2 ticks: " + l2.tickCount.get());
            Assert.assertTrue((l1.tickCount.get() > 7 ? 1 : 0) != 0);
            System.out.println("tickCount.get(): " + l2.tickCount.get() + " on l2: " + l2);
            Assert.assertEquals((long)0L, (long)l2.tickCount.get());
        }

        @Test
        public void testReset() {
            HystrixTimer timer = HystrixTimer.getInstance();
            TestListener l1 = new TestListener(50, "A");
            timer.addTimerListener(l1);
            ScheduledExecutor ex = (ScheduledExecutor)timer.executor.get();
            Assert.assertFalse((boolean)ex.executor.isShutdown());
            HystrixTimer.reset();
            Assert.assertTrue((boolean)ex.executor.isShutdown());
            Assert.assertNull(timer.executor.get());
            TestListener l2 = new TestListener(50, "A");
            timer.addTimerListener(l2);
            ScheduledExecutor ex2 = (ScheduledExecutor)timer.executor.get();
            Assert.assertFalse((boolean)ex2.executor.isShutdown());
            HystrixTimer.reset();
            HystrixTimer.reset();
        }

        public static void main(String[] args) {
            PlayListener l1 = new PlayListener();
            PlayListener l2 = new PlayListener();
            PlayListener l3 = new PlayListener();
            PlayListener l4 = new PlayListener();
            PlayListener l5 = new PlayListener();
            Reference<TimerListener> ref = HystrixTimer.getInstance().addTimerListener(l1);
            HystrixTimer.getInstance().addTimerListener(l2);
            HystrixTimer.getInstance().addTimerListener(l3);
            HystrixTimer.getInstance().addTimerListener(l4);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ref.clear();
            HystrixTimer.getInstance().addTimerListener(l5);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("counter: " + l1.counter);
            System.out.println("counter: " + l2.counter);
            System.out.println("counter: " + l3.counter);
            System.out.println("counter: " + l4.counter);
            System.out.println("counter: " + l5.counter);
        }

        public static class PlayListener
        implements TimerListener {
            int counter = 0;

            @Override
            public void tick() {
                ++this.counter;
            }

            @Override
            public int getIntervalTimeInMilliseconds() {
                return 10;
            }
        }

        private static class TestListener
        implements TimerListener {
            private final int interval;
            AtomicInteger tickCount = new AtomicInteger();

            TestListener(int interval, String value) {
                this.interval = interval;
            }

            @Override
            public void tick() {
                this.tickCount.incrementAndGet();
            }

            @Override
            public int getIntervalTimeInMilliseconds() {
                return this.interval;
            }
        }
    }

    public static interface TimerListener {
        public void tick();

        public int getIntervalTimeInMilliseconds();
    }

    private static class ScheduledExecutor {
        private volatile ScheduledThreadPoolExecutor executor;
        private volatile boolean initialized;

        private ScheduledExecutor() {
        }

        public void initialize() {
            this.executor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
                final AtomicInteger counter = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "HystrixTimer-" + this.counter.incrementAndGet());
                }
            });
            this.initialized = true;
        }

        public ScheduledThreadPoolExecutor getThreadPool() {
            return this.executor;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }

    private class TimerReference
    extends SoftReference<TimerListener> {
        private final ScheduledFuture<?> f;

        TimerReference(TimerListener referent, ScheduledFuture<?> f) {
            super(referent);
            this.f = f;
        }

        @Override
        public void clear() {
            super.clear();
            this.f.cancel(false);
        }
    }
}

