/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;

public class Hystrix {
    private static final Logger logger = LoggerFactory.getLogger(Hystrix.class);
    private static ThreadLocal<LinkedList<HystrixCommandKey>> currentCommand = new ThreadLocal<LinkedList<HystrixCommandKey>>(){

        @Override
        protected LinkedList<HystrixCommandKey> initialValue() {
            return new LinkedList<HystrixCommandKey>();
        }
    };

    public static void reset() {
        HystrixThreadPool.Factory.shutdown();
        Hystrix._reset();
    }

    public static void reset(long time, TimeUnit unit) {
        HystrixThreadPool.Factory.shutdown(time, unit);
        Hystrix._reset();
    }

    private static void _reset() {
        HystrixCommandMetrics.reset();
        HystrixThreadPoolMetrics.reset();
        HystrixCollapserMetrics.reset();
        HystrixCollapser.reset();
        HystrixCircuitBreaker.Factory.reset();
        HystrixPlugins.reset();
        HystrixPropertiesFactory.reset();
        currentCommand.set(new LinkedList());
    }

    public static HystrixCommandKey getCurrentThreadExecutingCommand() {
        if (currentCommand == null) {
            return null;
        }
        return currentCommand.get().peek();
    }

    static Action0 startCurrentThreadExecutingCommand(HystrixCommandKey key) {
        final LinkedList<HystrixCommandKey> list = currentCommand.get();
        try {
            list.push(key);
        }
        catch (Exception e) {
            logger.warn("Unable to record command starting", (Throwable)e);
        }
        return new Action0(){

            public void call() {
                Hystrix.endCurrentThreadExecutingCommand(list);
            }
        };
    }

    static void endCurrentThreadExecutingCommand() {
        Hystrix.endCurrentThreadExecutingCommand(currentCommand.get());
    }

    private static void endCurrentThreadExecutingCommand(LinkedList<HystrixCommandKey> list) {
        try {
            if (!list.isEmpty()) {
                list.pop();
            }
        }
        catch (NoSuchElementException e) {
            logger.debug("No command found to end.", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Unable to end command.", (Throwable)e);
        }
    }
}

