/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import java.util.concurrent.ConcurrentHashMap;

public interface HystrixCommandGroupKey {
    public String name();

    public static class Factory {
        private static ConcurrentHashMap<String, HystrixCommandGroupKey> intern = new ConcurrentHashMap();

        private Factory() {
        }

        public static HystrixCommandGroupKey asKey(String name) {
            HystrixCommandGroupKey k = intern.get(name);
            if (k == null) {
                intern.putIfAbsent(name, new HystrixCommandGroupDefault(name));
            }
            return intern.get(name);
        }

        static int getGroupCount() {
            return intern.size();
        }

        private static class HystrixCommandGroupDefault
        implements HystrixCommandGroupKey {
            private String name;

            private HystrixCommandGroupDefault(String name) {
                this.name = name;
            }

            @Override
            public String name() {
                return this.name;
            }
        }
    }
}

