/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.metrics.eventstream;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.contrib.sample.stream.HystrixSampleSseServlet;
import com.netflix.hystrix.metric.consumer.HystrixDashboardStream;
import com.netflix.hystrix.serial.SerialHystrixDashboardData;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.functions.Func1;

public class HystrixMetricsStreamServlet
extends HystrixSampleSseServlet {
    private static final long serialVersionUID = -7548505095303313237L;
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);
    private static DynamicIntProperty maxConcurrentConnections = DynamicPropertyFactory.getInstance().getIntProperty("hystrix.config.stream.maxConcurrentConnections", 5);

    public HystrixMetricsStreamServlet() {
        this((Observable<HystrixDashboardStream.DashboardData>)HystrixDashboardStream.getInstance().observe(), 500);
    }

    HystrixMetricsStreamServlet(Observable<HystrixDashboardStream.DashboardData> sampleStream, int pausePollerThreadDelayInMs) {
        super((Observable<String>)sampleStream.concatMap((Func1)new Func1<HystrixDashboardStream.DashboardData, Observable<String>>(){

            public Observable<String> call(HystrixDashboardStream.DashboardData dashboardData) {
                return Observable.from((Iterable)SerialHystrixDashboardData.toMultipleJsonStrings((HystrixDashboardStream.DashboardData)dashboardData));
            }
        }), pausePollerThreadDelayInMs);
    }

    @Override
    protected int getMaxNumberConcurrentConnectionsAllowed() {
        return maxConcurrentConnections.get();
    }

    @Override
    protected int getNumberCurrentConnections() {
        return concurrentConnections.get();
    }

    @Override
    protected int incrementAndGetCurrentConcurrentConnections() {
        return concurrentConnections.incrementAndGet();
    }

    @Override
    protected void decrementCurrentConcurrentConnections() {
        concurrentConnections.decrementAndGet();
    }
}

