/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.spi;

import com.netflix.eventbus.spi.Subscribe;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatchAllSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatchAllSubscriber.class);
    public static final int SUBSCRIBER_QUEUE_SIZE = 100;
    private AtomicReference<BlockingQueue> sink = new AtomicReference<Object>(null);

    @Subscribe(queueSize=100)
    public void receive(Object event) {
        BlockingQueue sinkNow = this.sink.get();
        if (null != sinkNow && !sinkNow.offer(event)) {
            LOGGER.info("CatchAllSubscriber sink full, rejected an event.");
        }
    }

    public boolean enable(BlockingQueue sink) {
        return this.sink.compareAndSet(null, sink);
    }

    public void disable() {
        this.sink.set(null);
    }

    public boolean isEnabled() {
        return this.sink.get() != null;
    }
}

