/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SynchronizedObserver;

public final class OperationSynchronize<T> {
    public static <T> Observable.OnSubscribeFunc<T> synchronize(Observable<? extends T> observable) {
        return new Synchronize<T>(observable);
    }

    public static class UnitTest {
        @Test
        public void testOnCompletedAfterUnSubscribe() {
            TestObservable t = new TestObservable(null);
            Observable<String> st = Observable.create(OperationSynchronize.synchronize(Observable.create(t)));
            Observer w = (Observer)Mockito.mock(Observer.class);
            Subscription ws = st.subscribe(w);
            t.sendOnNext("one");
            ws.unsubscribe();
            t.sendOnCompleted();
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testOnNextAfterUnSubscribe() {
            TestObservable t = new TestObservable(null);
            Observable<String> st = Observable.create(OperationSynchronize.synchronize(Observable.create(t)));
            Observer w = (Observer)Mockito.mock(Observer.class);
            Subscription ws = st.subscribe(w);
            t.sendOnNext("one");
            ws.unsubscribe();
            t.sendOnNext("two");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onNext("two");
        }

        @Test
        public void testOnErrorAfterUnSubscribe() {
            TestObservable t = new TestObservable(null);
            Observable<String> st = Observable.create(OperationSynchronize.synchronize(Observable.create(t)));
            Observer w = (Observer)Mockito.mock(Observer.class);
            Subscription ws = st.subscribe(w);
            t.sendOnNext("one");
            ws.unsubscribe();
            t.sendOnError(new RuntimeException("bad"));
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testOnNextAfterOnError() {
            TestObservable t = new TestObservable(null);
            Observable<String> st = Observable.create(OperationSynchronize.synchronize(Observable.create(t)));
            Observer w = (Observer)Mockito.mock(Observer.class);
            Subscription ws = st.subscribe(w);
            t.sendOnNext("one");
            t.sendOnError(new RuntimeException("bad"));
            t.sendOnNext("two");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onNext("two");
        }

        @Test
        public void testOnCompletedAfterOnError() {
            TestObservable t = new TestObservable(null);
            Observable<String> st = Observable.create(OperationSynchronize.synchronize(Observable.create(t)));
            Observer w = (Observer)Mockito.mock(Observer.class);
            Subscription ws = st.subscribe(w);
            t.sendOnNext("one");
            t.sendOnError(new RuntimeException("bad"));
            t.sendOnCompleted();
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testOnNextAfterOnCompleted() {
            TestObservable t = new TestObservable(null);
            Observable<String> st = Observable.create(OperationSynchronize.synchronize(Observable.create(t)));
            Observer w = (Observer)Mockito.mock(Observer.class);
            Subscription ws = st.subscribe(w);
            t.sendOnNext("one");
            t.sendOnCompleted();
            t.sendOnNext("two");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testOnErrorAfterOnCompleted() {
            TestObservable t = new TestObservable(null);
            Observable<String> st = Observable.create(OperationSynchronize.synchronize(Observable.create(t)));
            Observer w = (Observer)Mockito.mock(Observer.class);
            Subscription ws = st.subscribe(w);
            t.sendOnNext("one");
            t.sendOnCompleted();
            t.sendOnError(new RuntimeException("bad"));
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            Observer<? super String> observer = null;

            public TestObservable(Subscription s) {
            }

            public void sendOnCompleted() {
                this.observer.onCompleted();
            }

            public void sendOnNext(String value) {
                this.observer.onNext(value);
            }

            public void sendOnError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public Subscription onSubscribe(Observer<? super String> observer) {
                this.observer = observer;
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                    }
                };
            }
        }
    }

    private static class Synchronize<T>
    implements Observable.OnSubscribeFunc<T> {
        private Observable<? extends T> innerObservable;
        private SynchronizedObserver<T> atomicObserver;

        public Synchronize(Observable<? extends T> innerObservable) {
            this.innerObservable = innerObservable;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            this.atomicObserver = new SynchronizedObserver<T>(observer, subscription);
            return subscription.wrap(this.innerObservable.subscribe(this.atomicObserver));
        }
    }
}

