/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.OperationMostRecent;
import rx.operators.OperationNext;
import rx.operators.OperationToFuture;
import rx.operators.OperationToIterator;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action1;
import rx.util.functions.Func1;

public class BlockingObservable<T> {
    private final Observable<? extends T> o;

    private BlockingObservable(Observable<? extends T> o) {
        this.o = o;
    }

    public static <T> BlockingObservable<T> from(Observable<? extends T> o) {
        return new BlockingObservable<T>(o);
    }

    private static <T> T _singleOrDefault(BlockingObservable<? extends T> source, boolean hasDefault, T defaultValue) {
        Iterator<T> it = source.toIterable().iterator();
        if (!it.hasNext()) {
            if (hasDefault) {
                return defaultValue;
            }
            throw new IllegalStateException("Expected single entry. Actually empty stream.");
        }
        T result = it.next();
        if (it.hasNext()) {
            throw new IllegalStateException("Expected single entry. Actually more than one entry.");
        }
        return result;
    }

    private Subscription protectivelyWrapAndSubscribe(Observer<? super T> observer) {
        SafeObservableSubscription subscription = new SafeObservableSubscription();
        return subscription.wrap(this.o.subscribe(new SafeObserver<T>(subscription, observer)));
    }

    public void forEach(final Action1<? super T> onNext) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exceptionFromOnError = new AtomicReference();
        this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e) {
                exceptionFromOnError.set(e);
                latch.countDown();
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for subscription to complete.", e);
        }
        if (exceptionFromOnError.get() != null) {
            if (exceptionFromOnError.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionFromOnError.get();
            }
            throw new RuntimeException((Throwable)exceptionFromOnError.get());
        }
    }

    public Iterator<T> getIterator() {
        return OperationToIterator.toIterator(this.o);
    }

    public T last() {
        T result = null;
        for (T value : this.toIterable()) {
            result = value;
        }
        return result;
    }

    public T last(Func1<? super T, Boolean> predicate) {
        return BlockingObservable.from(this.o.filter(predicate)).last();
    }

    public T lastOrDefault(T defaultValue) {
        boolean found = false;
        T result = null;
        for (T value : this.toIterable()) {
            found = true;
            result = value;
        }
        if (!found) {
            return defaultValue;
        }
        return result;
    }

    public T lastOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return BlockingObservable.from(this.o.filter(predicate)).lastOrDefault(defaultValue);
    }

    public Iterable<T> mostRecent(T initialValue) {
        return OperationMostRecent.mostRecent(this.o, initialValue);
    }

    public Iterable<T> next() {
        return OperationNext.next(this.o);
    }

    public T single() {
        return BlockingObservable._singleOrDefault(this, false, null);
    }

    public T single(Func1<? super T, Boolean> predicate) {
        return BlockingObservable._singleOrDefault(BlockingObservable.from(this.o.filter(predicate)), false, null);
    }

    public T singleOrDefault(T defaultValue) {
        return BlockingObservable._singleOrDefault(this, true, defaultValue);
    }

    public T singleOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return BlockingObservable._singleOrDefault(BlockingObservable.from(this.o.filter(predicate)), true, defaultValue);
    }

    public Future<T> toFuture() {
        return OperationToFuture.toFuture(this.o);
    }

    public Iterable<T> toIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return BlockingObservable.this.getIterator();
            }
        };
    }

    public static class UnitTest {
        @Mock
        Observer<Integer> w;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testLast() {
            BlockingObservable<String> obs = BlockingObservable.from(Observable.from("one", "two", "three"));
            Assert.assertEquals((Object)"three", (Object)obs.last());
        }

        @Test
        public void testLastEmptyObservable() {
            BlockingObservable obs = BlockingObservable.from(Observable.empty());
            Assert.assertNull(obs.last());
        }

        @Test
        public void testLastOrDefault() {
            BlockingObservable<Integer> observable = BlockingObservable.from(Observable.from(1, Integer.valueOf(0), -1));
            int last = observable.lastOrDefault(-100, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer args) {
                    return args >= 0;
                }
            });
            Assert.assertEquals((long)0L, (long)last);
        }

        @Test
        public void testLastOrDefault1() {
            BlockingObservable<String> observable = BlockingObservable.from(Observable.from("one", "two", "three"));
            Assert.assertEquals((Object)"three", (Object)observable.lastOrDefault("default"));
        }

        @Test
        public void testLastOrDefault2() {
            BlockingObservable<String> observable = BlockingObservable.from(Observable.empty());
            Assert.assertEquals((Object)"default", (Object)observable.lastOrDefault("default"));
        }

        @Test
        public void testLastOrDefaultWithPredicate() {
            BlockingObservable<Integer> observable = BlockingObservable.from(Observable.from(1, Integer.valueOf(0), -1));
            int last = observable.lastOrDefault(0, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer args) {
                    return args < 0;
                }
            });
            Assert.assertEquals((long)-1L, (long)last);
        }

        @Test
        public void testLastOrDefaultWrongPredicate() {
            BlockingObservable<Integer> observable = BlockingObservable.from(Observable.from(-1, Integer.valueOf(-2), -3));
            int last = observable.lastOrDefault(0, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer args) {
                    return args >= 0;
                }
            });
            Assert.assertEquals((long)0L, (long)last);
        }

        @Test
        public void testLastWithPredicate() {
            BlockingObservable<String> obs = BlockingObservable.from(Observable.from("one", "two", "three"));
            Assert.assertEquals((Object)"two", (Object)obs.last(new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    return s.length() == 3;
                }
            }));
        }

        public void testSingle() {
            BlockingObservable<String> observable = BlockingObservable.from(Observable.from("one"));
            Assert.assertEquals((Object)"one", (Object)observable.single());
        }

        @Test
        public void testSingleDefault() {
            BlockingObservable<String> observable = BlockingObservable.from(Observable.empty());
            Assert.assertEquals((Object)"default", (Object)observable.singleOrDefault("default"));
        }

        @Test(expected=IllegalStateException.class)
        public void testSingleDefaultPredicateMatchesMoreThanOne() {
            BlockingObservable.from(Observable.from("one", "two")).singleOrDefault("default", new Func1<String, Boolean>(){

                @Override
                public Boolean call(String args) {
                    return args.length() == 3;
                }
            });
        }

        @Test
        public void testSingleDefaultPredicateMatchesNothing() {
            BlockingObservable<String> observable = BlockingObservable.from(Observable.from("one", "two"));
            String result = observable.singleOrDefault("default", new Func1<String, Boolean>(){

                @Override
                public Boolean call(String args) {
                    return args.length() == 4;
                }
            });
            Assert.assertEquals((Object)"default", (Object)result);
        }

        @Test(expected=IllegalStateException.class)
        public void testSingleDefaultWithMoreThanOne() {
            BlockingObservable<String> observable = BlockingObservable.from(Observable.from("one", "two", "three"));
            observable.singleOrDefault("default");
        }

        @Test
        public void testSingleWithPredicateDefault() {
            BlockingObservable<String> observable = BlockingObservable.from(Observable.from("one", "two", "four"));
            Assert.assertEquals((Object)"four", (Object)observable.single(new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    return s.length() == 4;
                }
            }));
        }

        @Test(expected=IllegalStateException.class)
        public void testSingleWrong() {
            BlockingObservable<Integer> observable = BlockingObservable.from(Observable.from(1, 2));
            observable.single();
        }

        @Test(expected=IllegalStateException.class)
        public void testSingleWrongPredicate() {
            BlockingObservable<Integer> observable = BlockingObservable.from(Observable.from(-1));
            observable.single(new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer args) {
                    return args > 0;
                }
            });
        }

        @Test
        public void testToIterable() {
            BlockingObservable<String> obs = BlockingObservable.from(Observable.from("one", "two", "three"));
            Iterator<String> it = obs.toIterable().iterator();
            Assert.assertEquals((Object)true, (Object)it.hasNext());
            Assert.assertEquals((Object)"one", (Object)it.next());
            Assert.assertEquals((Object)true, (Object)it.hasNext());
            Assert.assertEquals((Object)"two", (Object)it.next());
            Assert.assertEquals((Object)true, (Object)it.hasNext());
            Assert.assertEquals((Object)"three", (Object)it.next());
            Assert.assertEquals((Object)false, (Object)it.hasNext());
        }

        @Test(expected=TestException.class)
        public void testToIterableWithException() {
            BlockingObservable<String> obs = BlockingObservable.from(Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    observer.onNext("one");
                    observer.onError(new TestException());
                    return Subscriptions.empty();
                }
            }));
            Iterator<String> it = obs.toIterable().iterator();
            Assert.assertEquals((Object)true, (Object)it.hasNext());
            Assert.assertEquals((Object)"one", (Object)it.next());
            Assert.assertEquals((Object)true, (Object)it.hasNext());
            it.next();
        }

        @Test
        public void testForEachWithError() {
            try {
                BlockingObservable.from(Observable.create(new Observable.OnSubscribeFunc<String>(){

                    @Override
                    public Subscription onSubscribe(final Observer<? super String> observer) {
                        BooleanSubscription subscription = new BooleanSubscription();
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                observer.onNext("one");
                                observer.onNext("two");
                                observer.onNext("three");
                                observer.onCompleted();
                            }
                        }).start();
                        return subscription;
                    }
                })).forEach(new Action1<String>(){

                    @Override
                    public void call(String t1) {
                        throw new RuntimeException("fail");
                    }
                });
                Assert.fail((String)"we expect an exception to be thrown");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static class TestException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private TestException() {
            }
        }
    }
}

