/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Comparator;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public final class OperationDistinctUntilChanged {
    public static <T> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source, Comparator<T> equalityComparator) {
        return new DistinctUntilChanged(source, Functions.identity(), equalityComparator);
    }

    public static <T, U> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
        return new DistinctUntilChanged(source, keySelector, equalityComparator);
    }

    public static <T, U> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
        return new DistinctUntilChanged(source, keySelector, new DefaultEqualityComparator());
    }

    public static <T> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source) {
        return new DistinctUntilChanged(source, Functions.identity(), new DefaultEqualityComparator());
    }

    public static class UnitTest {
        @Mock
        Observer<? super String> w;
        @Mock
        Observer<? super String> w2;
        final Func1<String, String> TO_UPPER_WITH_EXCEPTION = new Func1<String, String>(){

            @Override
            public String call(String s) {
                if (s.equals("x")) {
                    return "xx";
                }
                return s.toUpperCase();
            }
        };
        final Comparator<String> COMPARE_LENGTH = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.length() - s2.length();
            }
        };

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testDistinctUntilChangedOfNone() {
            Observable src = Observable.empty();
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src)).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testDistinctUntilChangedOfNoneWithKeySelector() {
            Observable src = Observable.empty();
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src, this.TO_UPPER_WITH_EXCEPTION)).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testDistinctUntilChangedOfNormalSource() {
            Observable<String> src = Observable.from("a", "b", "c", "c", "c", "b", "b", "a", "e");
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("e");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctUntilChangedOfNormalSourceWithKeySelector() {
            Observable<String> src = Observable.from("a", "b", "c", "C", "c", "B", "b", "a", "e");
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src, this.TO_UPPER_WITH_EXCEPTION)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("B");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("e");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctUntilChangedOfSourceWithNulls() {
            Observable<Object> src = Observable.from(null, "a", "a", null, null, "b", null, null);
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(null);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(null);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(null);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctUntilChangedOfSourceWithExceptionsFromKeySelector() {
            Observable<String> src = Observable.from("a", "b", null, "c");
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src, this.TO_UPPER_WITH_EXCEPTION)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(NullPointerException.class));
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)inOrder.verify(this.w, Mockito.never())).onCompleted();
        }

        @Test
        public void testDistinctUntilChangedWithComparator() {
            Observable<String> src = Observable.from("a", "b", "c", "aa", "bb", "c", "ddd");
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src, this.COMPARE_LENGTH)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("aa");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("ddd");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctUntilChangedWithComparatorAndKeySelector() {
            Observable<String> src = Observable.from("a", "b", "x", "aa", "bb", "c", "ddd");
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src, this.TO_UPPER_WITH_EXCEPTION, this.COMPARE_LENGTH)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("x");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("ddd");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctUntilChangedWithComparatorAndKeySelectorandTwoSubscriptions() {
            Observable<String> src = Observable.from("a", "b", "x", "aa", "bb", "c", "ddd");
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src, this.TO_UPPER_WITH_EXCEPTION, this.COMPARE_LENGTH)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("x");
            Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(src, this.TO_UPPER_WITH_EXCEPTION, this.COMPARE_LENGTH)).subscribe(this.w2);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("ddd");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            InOrder inOrder2 = Mockito.inOrder((Object[])new Object[]{this.w2});
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("x");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("ddd");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder2.verify(this.w2, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }
    }

    private static class DistinctUntilChanged<T, U>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, ? extends U> keySelector;
        private final Comparator<U> equalityComparator;

        private DistinctUntilChanged(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
            this.source = source;
            this.keySelector = keySelector;
            this.equalityComparator = equalityComparator;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.subscribe(new Observer<T>(){
                private U lastEmittedKey;
                private boolean hasEmitted;

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    Object lastKey = this.lastEmittedKey;
                    Object nextKey = DistinctUntilChanged.this.keySelector.call(next);
                    this.lastEmittedKey = nextKey;
                    if (!this.hasEmitted) {
                        this.hasEmitted = true;
                        observer.onNext(next);
                    } else if (DistinctUntilChanged.this.equalityComparator.compare(lastKey, nextKey) != 0) {
                        observer.onNext(next);
                    }
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }

    private static class DefaultEqualityComparator<T>
    implements Comparator<T> {
        private DefaultEqualityComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            if (t1 == null) {
                return t2 == null ? 0 : 1;
            }
            return t1.equals(t2) ? 0 : 1;
        }
    }
}

