/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public final class OperationFirstOrDefault {
    public static <T> Observable.OnSubscribeFunc<T> firstOrDefault(Observable<? extends T> source, Func1<? super T, Boolean> predicate, T defaultValue) {
        return new FirstOrElse(source, predicate, defaultValue);
    }

    public static <T> Observable.OnSubscribeFunc<T> firstOrDefault(Observable<? extends T> source, T defaultValue) {
        return new FirstOrElse(source, Functions.alwaysTrue(), defaultValue);
    }

    private static class FirstOrElse<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, Boolean> predicate;
        private final T defaultValue;

        private FirstOrElse(Observable<? extends T> source, Func1<? super T, Boolean> predicate, T defaultValue) {
            this.source = source;
            this.defaultValue = defaultValue;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.subscribe(new Observer<T>(){
                private final AtomicBoolean hasEmitted = new AtomicBoolean(false);

                @Override
                public void onCompleted() {
                    if (!this.hasEmitted.get()) {
                        observer.onNext(FirstOrElse.this.defaultValue);
                        observer.onCompleted();
                    }
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    try {
                        if (!this.hasEmitted.get() && ((Boolean)FirstOrElse.this.predicate.call(next)).booleanValue()) {
                            this.hasEmitted.set(true);
                            observer.onNext(next);
                            observer.onCompleted();
                        }
                    }
                    catch (Throwable t) {
                        observer.onError(t);
                    }
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }
}

