/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Subscription;

public final class OperationSkip {
    public static <T> Observable.OnSubscribeFunc<T> skip(final Observable<? extends T> items, final int num) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Skip(items, num).onSubscribe(observer);
            }
        };
    }

    private static class Skip<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int num;
        private final Observable<? extends T> items;

        Skip(Observable<? extends T> items, int num) {
            this.num = num;
            this.items = items;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.items.subscribe(new ItemObserver(observer));
        }

        private class ItemObserver
        implements Observer<T> {
            private AtomicInteger counter = new AtomicInteger();
            private final Observer<? super T> observer;

            public ItemObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T args) {
                if (this.counter.incrementAndGet() > Skip.this.num) {
                    this.observer.onNext(args);
                }
            }
        }
    }
}

