/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.util.functions.Action0;
import rx.util.functions.Func2;

public class OperationSubscribeOn {
    public static <T> Observable.OnSubscribeFunc<T> subscribeOn(Observable<? extends T> source, Scheduler scheduler) {
        return new SubscribeOn<T>(source, scheduler);
    }

    private static class ScheduledSubscription
    implements Subscription {
        private final Subscription underlying;
        private final Scheduler scheduler;

        private ScheduledSubscription(Subscription underlying, Scheduler scheduler) {
            this.underlying = underlying;
            this.scheduler = scheduler;
        }

        @Override
        public void unsubscribe() {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    ScheduledSubscription.this.underlying.unsubscribe();
                }
            });
        }
    }

    private static class SubscribeOn<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Scheduler scheduler;

        public SubscribeOn(Observable<? extends T> source, Scheduler scheduler) {
            this.source = source;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            return this.scheduler.schedule(null, new Func2<Scheduler, T, Subscription>(){

                @Override
                public Subscription call(Scheduler s, T t) {
                    return new ScheduledSubscription(SubscribeOn.this.source.subscribe(observer), SubscribeOn.this.scheduler);
                }
            });
        }
    }
}

