/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import rx.Observable;
import rx.Observer;
import rx.Subscription;

public final class OperationToObservableList<T> {
    public static <T> Observable.OnSubscribeFunc<List<T>> toObservableList(Observable<? extends T> that) {
        return new ToObservableList<T>(that);
    }

    private static class ToObservableList<T>
    implements Observable.OnSubscribeFunc<List<T>> {
        private final Observable<? extends T> that;

        public ToObservableList(Observable<? extends T> that) {
            this.that = that;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super List<T>> observer) {
            return this.that.subscribe(new Observer<T>(){
                final ConcurrentLinkedQueue<T> list = new ConcurrentLinkedQueue();

                @Override
                public void onNext(T value) {
                    this.list.add(value);
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    try {
                        ArrayList l = new ArrayList(this.list.size());
                        for (Object t : this.list) {
                            l.add(t);
                        }
                        observer.onNext(l);
                        observer.onCompleted();
                    }
                    catch (Throwable e) {
                        this.onError(e);
                    }
                }
            });
        }
    }
}

