/*
 * Decompiled with CFR 0.152.
 */
package rx.concurrency;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.DiscardableAction;
import rx.concurrency.GenericScheduledExecutorService;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func2;

public class ExecutorScheduler
extends Scheduler {
    private final Executor executor;

    public ExecutorScheduler(Executor executor) {
        this.executor = executor;
    }

    public ExecutorScheduler(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public <T> Subscription schedulePeriodically(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long initialDelay, long period, TimeUnit unit) {
        if (this.executor instanceof ScheduledExecutorService) {
            final CompositeSubscription subscriptions = new CompositeSubscription(new Subscription[0]);
            ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Subscription s = (Subscription)action.call(ExecutorScheduler.this, state);
                    subscriptions.add(s);
                }
            }, initialDelay, period, unit);
            subscriptions.add(Subscriptions.from(f));
            return subscriptions;
        }
        return super.schedulePeriodically(state, action, initialDelay, period, unit);
    }

    @Override
    public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
        final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
        final ExecutorScheduler _scheduler = this;
        final CompositeSubscription subscription = new CompositeSubscription(discardableAction);
        if (this.executor instanceof ScheduledExecutorService) {
            ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).schedule(new Runnable(){

                @Override
                public void run() {
                    Subscription s = discardableAction.call(_scheduler);
                    subscription.add(s);
                }
            }, delayTime, unit);
            subscription.add(Subscriptions.from(f));
        } else if (delayTime == 0L) {
            Subscription s = this.schedule(state, action);
            subscription.add(s);
        } else {
            ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                @Override
                public void run() {
                    Subscription s = _scheduler.schedule(state, action);
                    subscription.add(s);
                }
            }, delayTime, unit);
            subscription.add(Subscriptions.from(f));
        }
        return subscription;
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
        final ExecutorScheduler _scheduler = this;
        final CompositeSubscription subscription = new CompositeSubscription(discardableAction);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Subscription s = discardableAction.call(_scheduler);
                subscription.add(s);
            }
        };
        if (this.executor instanceof ExecutorService) {
            Future<?> f = ((ExecutorService)this.executor).submit(r);
            subscription.add(Subscriptions.from(f));
        } else {
            this.executor.execute(r);
        }
        return subscription;
    }
}

