/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.operators.ChunkedOperation;
import rx.util.Closing;
import rx.util.Opening;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public final class OperationBuffer
extends ChunkedOperation {
    private static <T> Func0<Buffer<T>> bufferMaker() {
        return new Func0<Buffer<T>>(){

            @Override
            public Buffer<T> call() {
                return new Buffer();
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final Func0<? extends Observable<? extends Closing>> bufferClosingSelector) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.NonOverlappingChunks buffers = new ChunkedOperation.NonOverlappingChunks(observer, OperationBuffer.bufferMaker());
                ChunkedOperation.ObservableBasedSingleChunkCreator creator = new ChunkedOperation.ObservableBasedSingleChunkCreator(buffers, bufferClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final Observable<? extends Opening> bufferOpenings, final Func1<Opening, ? extends Observable<? extends Closing>> bufferClosingSelector) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.OverlappingChunks buffers = new ChunkedOperation.OverlappingChunks(observer, OperationBuffer.bufferMaker());
                ChunkedOperation.ObservableBasedMultiChunkCreator creator = new ChunkedOperation.ObservableBasedMultiChunkCreator(buffers, bufferOpenings, bufferClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, int count) {
        return OperationBuffer.buffer(source, count, count);
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final int count, final int skip) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.SizeBasedChunks chunks = new ChunkedOperation.SizeBasedChunks(observer, OperationBuffer.bufferMaker(), count);
                ChunkedOperation.SkippingChunkCreator creator = new ChunkedOperation.SkippingChunkCreator(chunks, skip);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, long timespan, TimeUnit unit) {
        return OperationBuffer.buffer(source, timespan, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final long timespan, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.NonOverlappingChunks buffers = new ChunkedOperation.NonOverlappingChunks(observer, OperationBuffer.bufferMaker());
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(buffers, timespan, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, long timespan, TimeUnit unit, int count) {
        return OperationBuffer.buffer(source, timespan, unit, count, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final long timespan, final TimeUnit unit, final int count, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.TimeAndSizeBasedChunks chunks = new ChunkedOperation.TimeAndSizeBasedChunks(observer, OperationBuffer.bufferMaker(), count, timespan, unit, scheduler);
                ChunkedOperation.SingleChunkCreator creator = new ChunkedOperation.SingleChunkCreator(chunks);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, long timespan, long timeshift, TimeUnit unit) {
        return OperationBuffer.buffer(source, timespan, timeshift, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final long timespan, final long timeshift, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.TimeBasedChunks buffers = new ChunkedOperation.TimeBasedChunks(observer, OperationBuffer.bufferMaker(), timespan, unit, scheduler);
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(buffers, timeshift, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    protected static class Buffer<T>
    extends ChunkedOperation.Chunk<T, List<T>> {
        protected Buffer() {
        }

        @Override
        public List<T> getContents() {
            return this.contents;
        }
    }
}

