/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;

public class OperationDoOnEach {
    public static <T> Observable.OnSubscribeFunc<T> doOnEach(Observable<? extends T> sequence, Observer<? super T> observer) {
        return new DoOnEachObservable<T>(sequence, observer);
    }

    private static class DoOnEachObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> sequence;
        private final Observer<? super T> doOnEachObserver;

        public DoOnEachObservable(Observable<? extends T> sequence, Observer<? super T> doOnEachObserver) {
            this.sequence = sequence;
            this.doOnEachObserver = doOnEachObserver;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.sequence.subscribe(new SafeObserver(subscription, new Observer<T>(){

                @Override
                public void onCompleted() {
                    DoOnEachObservable.this.doOnEachObserver.onCompleted();
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    DoOnEachObservable.this.doOnEachObserver.onError(e);
                    observer.onError(e);
                }

                @Override
                public void onNext(T value) {
                    DoOnEachObservable.this.doOnEachObserver.onNext(value);
                    observer.onNext(value);
                }
            })));
        }
    }
}

