/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.CompositeException;
import rx.util.functions.Func1;

public final class OperationOnErrorResumeNextViaFunction<T> {
    public static <T> Observable.OnSubscribeFunc<T> onErrorResumeNextViaFunction(Observable<? extends T> originalSequence, Func1<Throwable, ? extends Observable<? extends T>> resumeFunction) {
        return new OnErrorResumeNextViaFunction<T>(originalSequence, resumeFunction);
    }

    private static class OnErrorResumeNextViaFunction<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Func1<Throwable, ? extends Observable<? extends T>> resumeFunction;
        private final Observable<? extends T> originalSequence;

        public OnErrorResumeNextViaFunction(Observable<? extends T> originalSequence, Func1<Throwable, ? extends Observable<? extends T>> resumeFunction) {
            this.resumeFunction = resumeFunction;
            this.originalSequence = originalSequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final AtomicReference<SafeObservableSubscription> subscriptionRef = new AtomicReference<SafeObservableSubscription>(new SafeObservableSubscription());
            subscriptionRef.get().wrap(new SafeObservableSubscription(this.originalSequence.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    observer.onNext(value);
                }

                @Override
                public void onError(Throwable ex) {
                    SafeObservableSubscription currentSubscription = (SafeObservableSubscription)subscriptionRef.get();
                    if (currentSubscription != null) {
                        try {
                            Observable resumeSequence = (Observable)OnErrorResumeNextViaFunction.this.resumeFunction.call(ex);
                            SafeObservableSubscription innerSubscription = new SafeObservableSubscription(resumeSequence.subscribe(observer));
                            if (!subscriptionRef.compareAndSet(currentSubscription, innerSubscription)) {
                                innerSubscription.unsubscribe();
                            }
                        }
                        catch (Throwable e) {
                            observer.onError(new CompositeException("OnErrorResume function failed", Arrays.asList(ex, e)));
                        }
                    }
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            })));
            return new Subscription(){

                @Override
                public void unsubscribe() {
                    Subscription s = subscriptionRef.getAndSet(null);
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            };
        }
    }
}

