/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subjects.Subject;

public class BehaviorSubject<T>
extends Subject<T, T> {
    private final ConcurrentHashMap<Subscription, Observer<? super T>> observers;
    private final AtomicReference<T> currentValue;

    public static <T> BehaviorSubject<T> createWithDefaultValue(T defaultValue) {
        final ConcurrentHashMap<Subscription, Observer<? super T>> observers = new ConcurrentHashMap<Subscription, Observer<? super T>>();
        final AtomicReference<T> currentValue = new AtomicReference<T>(defaultValue);
        Observable.OnSubscribeFunc onSubscribe = new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                final SafeObservableSubscription subscription = new SafeObservableSubscription();
                subscription.wrap(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        observers.remove(subscription);
                    }
                });
                observer.onNext(currentValue.get());
                observers.put(subscription, observer);
                return subscription;
            }
        };
        return new BehaviorSubject<T>(currentValue, onSubscribe, observers);
    }

    protected BehaviorSubject(AtomicReference<T> currentValue, Observable.OnSubscribeFunc<T> onSubscribe, ConcurrentHashMap<Subscription, Observer<? super T>> observers) {
        super(onSubscribe);
        this.currentValue = currentValue;
        this.observers = observers;
    }

    @Override
    public void onCompleted() {
        for (Observer<T> observer : this.observers.values()) {
            observer.onCompleted();
        }
    }

    @Override
    public void onError(Throwable e) {
        for (Observer<T> observer : this.observers.values()) {
            observer.onError(e);
        }
    }

    @Override
    public void onNext(T args) {
        this.currentValue.set(args);
        for (Observer<T> observer : this.observers.values()) {
            observer.onNext(args);
        }
    }
}

