/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Action0;

public final class OperationFinally {
    public static <T> Observable.OnSubscribeFunc<T> finallyDo(final Observable<? extends T> sequence, final Action0 action) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Finally(sequence, action).onSubscribe(observer);
            }
        };
    }

    public static class UnitTest {
        private Action0 aAction0;
        private Observer<String> aObserver;

        @Before
        public void before() {
            this.aAction0 = (Action0)Mockito.mock(Action0.class);
            this.aObserver = (Observer)Mockito.mock(Observer.class);
        }

        private void checkActionCalled(Observable<String> input) {
            Observable.create(OperationFinally.finallyDo(input, this.aAction0)).subscribe(this.aObserver);
            ((Action0)Mockito.verify((Object)this.aAction0, (VerificationMode)Mockito.times((int)1))).call();
        }

        @Test
        public void testFinallyCalledOnComplete() {
            this.checkActionCalled(Observable.from(new String[]{"1", "2", "3"}));
        }

        @Test
        public void testFinallyCalledOnError() {
            this.checkActionCalled(Observable.error(new RuntimeException("expected")));
        }
    }

    private static class Finally<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> sequence;
        private final Action0 finalAction;

        Finally(Observable<? extends T> sequence, Action0 finalAction) {
            this.sequence = sequence;
            this.finalAction = finalAction;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.sequence.subscribe(new FinallyObserver(observer));
        }

        private class FinallyObserver
        implements Observer<T> {
            private final Observer<? super T> observer;

            FinallyObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                try {
                    this.observer.onCompleted();
                }
                finally {
                    Finally.this.finalAction.call();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                try {
                    this.observer.onError(e);
                }
                finally {
                    Finally.this.finalAction.call();
                }
            }

            @Override
            public void onNext(T args) {
                this.observer.onNext(args);
            }
        }
    }
}

