/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.CompositeException;
import rx.util.functions.Func1;

public final class OperationOnErrorReturn<T> {
    public static <T> Observable.OnSubscribeFunc<T> onErrorReturn(Observable<? extends T> originalSequence, Func1<Throwable, ? extends T> resumeFunction) {
        return new OnErrorReturn<T>(originalSequence, resumeFunction);
    }

    public static class UnitTest {
        @Test
        public void testResumeNext() {
            Subscription s = (Subscription)Mockito.mock(Subscription.class);
            TestObservable f = new TestObservable(s, "one");
            Observable<String> w = Observable.create(f);
            final AtomicReference capturedException = new AtomicReference();
            Observable<String> observable = Observable.create(OperationOnErrorReturn.onErrorReturn(w, new Func1<Throwable, String>(){

                @Override
                public String call(Throwable e) {
                    capturedException.set(e);
                    return "failure";
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            try {
                f.t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("failure");
            Assert.assertNotNull(capturedException.get());
        }

        @Test
        public void testFunctionThrowsError() {
            Subscription s = (Subscription)Mockito.mock(Subscription.class);
            TestObservable f = new TestObservable(s, "one");
            Observable<String> w = Observable.create(f);
            final AtomicReference capturedException = new AtomicReference();
            Observable<String> observable = Observable.create(OperationOnErrorReturn.onErrorReturn(w, new Func1<Throwable, String>(){

                @Override
                public String call(Throwable e) {
                    capturedException.set(e);
                    throw new RuntimeException("exception from function");
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            try {
                f.t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onCompleted();
            Assert.assertNotNull(capturedException.get());
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            final Subscription s;
            final String[] values;
            Thread t = null;

            public TestObservable(Subscription s, String ... values) {
                this.s = s;
                this.values = values;
            }

            @Override
            public Subscription onSubscribe(final Observer<? super String> observer) {
                System.out.println("TestObservable subscribed to ...");
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            System.out.println("running TestObservable thread");
                            for (String s : TestObservable.this.values) {
                                System.out.println("TestObservable onNext: " + s);
                                observer.onNext(s);
                            }
                            throw new RuntimeException("Forced Failure");
                        }
                        catch (Throwable e) {
                            observer.onError(e);
                            return;
                        }
                    }
                });
                System.out.println("starting TestObservable thread");
                this.t.start();
                System.out.println("done starting TestObservable thread");
                return this.s;
            }
        }
    }

    private static class OnErrorReturn<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Func1<Throwable, ? extends T> resumeFunction;
        private final Observable<? extends T> originalSequence;

        public OnErrorReturn(Observable<? extends T> originalSequence, Func1<Throwable, ? extends T> resumeFunction) {
            this.resumeFunction = resumeFunction;
            this.originalSequence = originalSequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            final AtomicReference<SafeObservableSubscription> subscriptionRef = new AtomicReference<SafeObservableSubscription>(subscription);
            subscription.wrap(this.originalSequence.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    observer.onNext(value);
                }

                @Override
                public void onError(Throwable ex) {
                    SafeObservableSubscription currentSubscription = (SafeObservableSubscription)subscriptionRef.get();
                    if (currentSubscription != null) {
                        try {
                            this.onNext(OnErrorReturn.this.resumeFunction.call(ex));
                            this.onCompleted();
                            currentSubscription.unsubscribe();
                        }
                        catch (Throwable e) {
                            observer.onError(new CompositeException("OnErrorReturn function failed", Arrays.asList(ex, e)));
                        }
                    }
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            }));
            return new Subscription(){

                @Override
                public void unsubscribe() {
                    Subscription s = subscriptionRef.getAndSet(null);
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            };
        }
    }
}

