/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public final class OperationAny {
    public static <T> Observable.OnSubscribeFunc<Boolean> any(Observable<? extends T> source) {
        return new Any(source, Functions.alwaysTrue(), false);
    }

    public static <T> Observable.OnSubscribeFunc<Boolean> isEmpty(Observable<? extends T> source) {
        return new Any(source, Functions.alwaysTrue(), true);
    }

    public static <T> Observable.OnSubscribeFunc<Boolean> any(Observable<? extends T> source, Func1<? super T, Boolean> predicate) {
        return new Any(source, predicate, false);
    }

    public static <T> Observable.OnSubscribeFunc<Boolean> exists(Observable<? extends T> source, Func1<? super T, Boolean> predicate) {
        return OperationAny.any(source, predicate);
    }

    public static class UnitTest {
        @Test
        public void testAnyWithTwoItems() {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Boolean> observable = Observable.create(OperationAny.any(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testIsEmptyWithTwoItems() {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Boolean> observable = Observable.create(OperationAny.isEmpty(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAnyWithOneItem() {
            Observable<Integer> w = Observable.from(1);
            Observable<Boolean> observable = Observable.create(OperationAny.any(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testIsEmptyWithOneItem() {
            Observable<Integer> w = Observable.from(1);
            Observable<Boolean> observable = Observable.create(OperationAny.isEmpty(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAnyWithEmpty() {
            Observable w = Observable.empty();
            Observable<Boolean> observable = Observable.create(OperationAny.any(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testIsEmptyWithEmpty() {
            Observable w = Observable.empty();
            Observable<Boolean> observable = Observable.create(OperationAny.isEmpty(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAnyWithPredicate1() {
            Observable<Integer> w = Observable.from(1, Integer.valueOf(2), 3);
            Observable<Boolean> observable = Observable.create(OperationAny.any(w, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer t1) {
                    return t1 < 2;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testExists1() {
            Observable<Integer> w = Observable.from(1, Integer.valueOf(2), 3);
            Observable<Boolean> observable = Observable.create(OperationAny.exists(w, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer t1) {
                    return t1 < 2;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAnyWithPredicate2() {
            Observable<Integer> w = Observable.from(1, Integer.valueOf(2), 3);
            Observable<Boolean> observable = Observable.create(OperationAny.any(w, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer t1) {
                    return t1 < 1;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAnyWithEmptyAndPredicate() {
            Observable w = Observable.empty();
            Observable<Boolean> observable = Observable.create(OperationAny.any(w, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer t1) {
                    return true;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(false);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(true);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class Any<T>
    implements Observable.OnSubscribeFunc<Boolean> {
        private final Observable<? extends T> source;
        private final Func1<? super T, Boolean> predicate;
        private final boolean returnOnEmpty;

        private Any(Observable<? extends T> source, Func1<? super T, Boolean> predicate, boolean returnOnEmpty) {
            this.source = source;
            this.predicate = predicate;
            this.returnOnEmpty = returnOnEmpty;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Boolean> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.subscribe(new Observer<T>(){
                private final AtomicBoolean hasEmitted = new AtomicBoolean(false);

                @Override
                public void onNext(T value) {
                    try {
                        if (!this.hasEmitted.get() && ((Boolean)Any.this.predicate.call(value)).booleanValue() && !this.hasEmitted.getAndSet(true)) {
                            observer.onNext(!Any.this.returnOnEmpty);
                            observer.onCompleted();
                            subscription.unsubscribe();
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    if (!this.hasEmitted.get()) {
                        observer.onNext(Any.this.returnOnEmpty);
                        observer.onCompleted();
                    }
                }
            }));
        }
    }
}

