/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Notification;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.util.functions.Func2;

class ScheduledObserver<T>
implements Observer<T> {
    private final Observer<? super T> underlying;
    private final Scheduler scheduler;
    private final CompositeSubscription parentSubscription;
    private final EventLoop eventLoop = new EventLoop();
    final AtomicInteger counter = new AtomicInteger();
    private final AtomicBoolean started = new AtomicBoolean();
    private final ConcurrentLinkedQueue<Notification<? extends T>> queue = new ConcurrentLinkedQueue();

    public ScheduledObserver(CompositeSubscription s, Observer<? super T> underlying, Scheduler scheduler) {
        this.parentSubscription = s;
        this.underlying = underlying;
        this.scheduler = scheduler;
    }

    @Override
    public void onCompleted() {
        this.enqueue(new Notification());
    }

    @Override
    public void onError(Throwable e) {
        this.enqueue(new Notification(e));
    }

    @Override
    public void onNext(T args) {
        this.enqueue(new Notification<T>(args));
    }

    private void enqueue(Notification<? extends T> notification) {
        this.queue.offer(notification);
        if (this.counter.getAndIncrement() <= 0) {
            if (!this.started.get() && this.started.compareAndSet(false, true)) {
                MultipleAssignmentSubscription recursiveSubscription = new MultipleAssignmentSubscription();
                this.parentSubscription.add(this.scheduler.schedule(recursiveSubscription, this.eventLoop));
                this.parentSubscription.add(recursiveSubscription);
            } else {
                this.eventLoop.reschedule();
            }
        }
    }

    private class EventLoop
    implements Func2<Scheduler, MultipleAssignmentSubscription, Subscription> {
        volatile Scheduler _recursiveScheduler;
        volatile MultipleAssignmentSubscription _recursiveSubscription;

        private EventLoop() {
        }

        public void reschedule() {
            this._recursiveSubscription.setSubscription(this._recursiveScheduler.schedule(this._recursiveSubscription, this));
        }

        @Override
        public Subscription call(Scheduler s, MultipleAssignmentSubscription recursiveSubscription) {
            if (this._recursiveScheduler == null) {
                this._recursiveScheduler = s;
            }
            if (this._recursiveSubscription == null) {
                this._recursiveSubscription = recursiveSubscription;
            }
            do {
                Notification notification;
                if ((notification = (Notification)ScheduledObserver.this.queue.poll()) == null) continue;
                if (ScheduledObserver.this.parentSubscription.isUnsubscribed()) {
                    return ScheduledObserver.this.parentSubscription;
                }
                switch (notification.getKind()) {
                    case OnNext: {
                        ScheduledObserver.this.underlying.onNext(notification.getValue());
                        break;
                    }
                    case OnError: {
                        ScheduledObserver.this.underlying.onError(notification.getThrowable());
                        break;
                    }
                    case OnCompleted: {
                        ScheduledObserver.this.underlying.onCompleted();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown kind of notification " + notification);
                    }
                }
            } while (ScheduledObserver.this.counter.decrementAndGet() > 0);
            return ScheduledObserver.this.parentSubscription;
        }
    }
}

