/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscription;

public final class OperationDematerialize {
    public static <T> Observable.OnSubscribeFunc<T> dematerialize(Observable<? extends Notification<? extends T>> sequence) {
        return new DematerializeObservable(sequence);
    }

    public static class UnitTest {
        @Test
        public void testDematerialize1() {
            Observable<Notification<Integer>> notifications = Observable.from(1, 2).materialize();
            Observable dematerialize = notifications.dematerialize();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            dematerialize.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDematerialize2() {
            Throwable exception = new Throwable("test");
            Observable observable = Observable.error(exception);
            Observable dematerialize = Observable.create(OperationDematerialize.dematerialize(observable.materialize()));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            dematerialize.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError(exception);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onNext(Mockito.any(Integer.class));
        }

        @Test
        public void testDematerialize3() {
            Exception exception = new Exception("test");
            Observable observable = Observable.error(exception);
            Observable dematerialize = Observable.create(OperationDematerialize.dematerialize(observable.materialize()));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            dematerialize.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError(exception);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onNext(Mockito.any(Integer.class));
        }
    }

    private static class DematerializeObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Notification<? extends T>> sequence;

        public DematerializeObservable(Observable<? extends Notification<? extends T>> sequence) {
            this.sequence = sequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            return this.sequence.subscribe(new Observer<Notification<? extends T>>(){

                @Override
                public void onCompleted() {
                }

                @Override
                public void onError(Throwable e) {
                }

                @Override
                public void onNext(Notification<? extends T> value) {
                    switch (value.getKind()) {
                        case OnNext: {
                            observer.onNext(value.getValue());
                            break;
                        }
                        case OnError: {
                            observer.onError(value.getThrowable());
                            break;
                        }
                        case OnCompleted: {
                            observer.onCompleted();
                        }
                    }
                }
            });
        }
    }
}

