/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.OperationToIterator;
import rx.operators.SafeObservableSubscription;

public class OperationElementAt {
    public static <T> Observable.OnSubscribeFunc<T> elementAt(Observable<? extends T> source, int index) {
        return new ElementAt(source, index, null, false);
    }

    public static <T> Observable.OnSubscribeFunc<T> elementAtOrDefault(Observable<? extends T> source, int index, T defaultValue) {
        return new ElementAt(source, index, defaultValue, true);
    }

    public static class UnitTest {
        @Test
        public void testElementAt() {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Integer> observable = Observable.create(OperationElementAt.elementAt(w, 1));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testElementAtWithMinusIndex() {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Integer> observable = Observable.create(OperationElementAt.elementAt(w, -1));
            try {
                Iterator<Integer> iter = OperationToIterator.toIterator(observable);
                Assert.assertTrue((boolean)iter.hasNext());
                iter.next();
                Assert.fail((String)"expect an IndexOutOfBoundsException when index is out of bounds");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        @Test
        public void testElementAtWithIndexOutOfBounds() throws InterruptedException, ExecutionException {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Integer> observable = Observable.create(OperationElementAt.elementAt(w, 2));
            try {
                Iterator<Integer> iter = OperationToIterator.toIterator(observable);
                Assert.assertTrue((boolean)iter.hasNext());
                iter.next();
                Assert.fail((String)"expect an IndexOutOfBoundsException when index is out of bounds");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        @Test
        public void testElementAtOrDefault() throws InterruptedException, ExecutionException {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Integer> observable = Observable.create(OperationElementAt.elementAtOrDefault(w, 1, 0));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testElementAtOrDefaultWithIndexOutOfBounds() throws InterruptedException, ExecutionException {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Integer> observable = Observable.create(OperationElementAt.elementAtOrDefault(w, 2, 0));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(0);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testElementAtOrDefaultWithMinusIndex() {
            Observable<Integer> w = Observable.from(1, 2);
            Observable<Integer> observable = Observable.create(OperationElementAt.elementAtOrDefault(w, -1, 0));
            try {
                Iterator<Integer> iter = OperationToIterator.toIterator(observable);
                Assert.assertTrue((boolean)iter.hasNext());
                iter.next();
                Assert.fail((String)"expect an IndexOutOfBoundsException when index is out of bounds");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private static class ElementAt<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final int index;
        private final boolean hasDefault;
        private final T defaultValue;

        private ElementAt(Observable<? extends T> source, int index, T defaultValue, boolean hasDefault) {
            this.source = source;
            this.index = index;
            this.defaultValue = defaultValue;
            this.hasDefault = hasDefault;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.subscribe(new Observer<T>(){
                private AtomicInteger counter = new AtomicInteger();

                @Override
                public void onNext(T value) {
                    try {
                        int currentIndex = this.counter.getAndIncrement();
                        if (currentIndex == ElementAt.this.index) {
                            observer.onNext(value);
                            observer.onCompleted();
                        } else if (currentIndex > ElementAt.this.index) {
                            subscription.unsubscribe();
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    if (ElementAt.this.index < 0) {
                        observer.onError(new IndexOutOfBoundsException(ElementAt.this.index + " is out of bounds"));
                    } else if (this.counter.get() <= ElementAt.this.index) {
                        if (ElementAt.this.hasDefault) {
                            observer.onNext(ElementAt.this.defaultValue);
                            observer.onCompleted();
                        } else {
                            observer.onError(new IndexOutOfBoundsException(ElementAt.this.index + " is out of bounds"));
                        }
                    }
                }
            }));
        }
    }
}

