/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subjects.Subject;
import rx.subjects.UnsubscribeTester;
import rx.util.functions.Action1;
import rx.util.functions.Func0;

public class BehaviorSubject<T>
extends Subject<T, T> {
    private final ConcurrentHashMap<Subscription, Observer<? super T>> observers;
    private final AtomicReference<T> currentValue;

    public static <T> BehaviorSubject<T> createWithDefaultValue(T defaultValue) {
        final ConcurrentHashMap<Subscription, Observer<? super T>> observers = new ConcurrentHashMap<Subscription, Observer<? super T>>();
        final AtomicReference<T> currentValue = new AtomicReference<T>(defaultValue);
        Observable.OnSubscribeFunc onSubscribe = new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                final SafeObservableSubscription subscription = new SafeObservableSubscription();
                subscription.wrap(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        observers.remove(subscription);
                    }
                });
                observer.onNext(currentValue.get());
                observers.put(subscription, observer);
                return subscription;
            }
        };
        return new BehaviorSubject<T>(currentValue, onSubscribe, observers);
    }

    protected BehaviorSubject(AtomicReference<T> currentValue, Observable.OnSubscribeFunc<T> onSubscribe, ConcurrentHashMap<Subscription, Observer<? super T>> observers) {
        super(onSubscribe);
        this.currentValue = currentValue;
        this.observers = observers;
    }

    @Override
    public void onCompleted() {
        for (Observer<T> observer : this.observers.values()) {
            observer.onCompleted();
        }
    }

    @Override
    public void onError(Throwable e) {
        for (Observer<T> observer : this.observers.values()) {
            observer.onError(e);
        }
    }

    @Override
    public void onNext(T args) {
        this.currentValue.set(args);
        for (Observer<T> observer : this.observers.values()) {
            observer.onNext(args);
        }
    }

    public static class UnitTest {
        private final Throwable testException = new Throwable();

        @Test
        public void testThatObserverReceivesDefaultValueIfNothingWasPublished() {
            BehaviorSubject<String> subject = BehaviorSubject.createWithDefaultValue("default");
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            subject.onNext("three");
            this.assertReceivedAllEvents(aObserver);
        }

        private void assertReceivedAllEvents(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("default");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onError(this.testException);
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testThatObserverDoesNotReceiveDefaultValueIfSomethingWasPublished() {
            BehaviorSubject<String> subject = BehaviorSubject.createWithDefaultValue("default");
            subject.onNext("one");
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("two");
            subject.onNext("three");
            this.assertDidNotReceiveTheDefaultValue(aObserver);
        }

        private void assertDidNotReceiveTheDefaultValue(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onNext("default");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onError(this.testException);
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testCompleted() {
            BehaviorSubject<String> subject = BehaviorSubject.createWithDefaultValue("default");
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onCompleted();
            this.assertCompletedObserver(aObserver);
        }

        private void assertCompletedObserver(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("default");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testCompletedAfterError() {
            BehaviorSubject<String> subject = BehaviorSubject.createWithDefaultValue("default");
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onError(this.testException);
            subject.onNext("two");
            subject.onCompleted();
            this.assertErrorObserver(aObserver);
        }

        private void assertErrorObserver(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("default");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onError(this.testException);
        }

        @Test
        public void testUnsubscribe() {
            UnsubscribeTester.test(new Func0<BehaviorSubject<String>>(){

                @Override
                public BehaviorSubject<String> call() {
                    return BehaviorSubject.createWithDefaultValue("default");
                }
            }, new Action1<BehaviorSubject<String>>(){

                @Override
                public void call(BehaviorSubject<String> DefaultSubject) {
                    DefaultSubject.onCompleted();
                }
            }, new Action1<BehaviorSubject<String>>(){

                @Override
                public void call(BehaviorSubject<String> DefaultSubject) {
                    DefaultSubject.onError(new Throwable());
                }
            }, new Action1<BehaviorSubject<String>>(){

                @Override
                public void call(BehaviorSubject<String> DefaultSubject) {
                    DefaultSubject.onNext("one");
                }
            });
        }
    }
}

