/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SynchronizedObserver;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func2;
import rx.util.functions.Func3;
import rx.util.functions.Func4;
import rx.util.functions.Func5;
import rx.util.functions.Func6;
import rx.util.functions.Func7;
import rx.util.functions.Func8;
import rx.util.functions.Func9;
import rx.util.functions.FuncN;
import rx.util.functions.Functions;

public class OperationCombineLatest {
    public static <T0, T1, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<T1> w1, Func2<? super T0, ? super T1, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        return a;
    }

    public static <T0, T1, T2, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Func3<? super T0, ? super T1, ? super T2, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        return a;
    }

    public static <T0, T1, T2, T3, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Func4<? super T0, ? super T1, ? super T2, ? super T3, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        return a;
    }

    public static <T0, T1, T2, T3, T4, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Func5<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Func6<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, T6, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Func7<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        a.addObserver(new CombineObserver<R, T6>(a, w6));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Observable<? extends T7> w7, Func8<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        a.addObserver(new CombineObserver<R, T6>(a, w6));
        a.addObserver(new CombineObserver<R, T7>(a, w7));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Observable<? extends T7> w7, Observable<? extends T8> w8, Func9<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        a.addObserver(new CombineObserver<R, T6>(a, w6));
        a.addObserver(new CombineObserver<R, T7>(a, w7));
        a.addObserver(new CombineObserver<R, T8>(a, w8));
        return a;
    }

    public static class UnitTest {
        @Test
        public void testCombineLatestWithFunctionThatThrowsAnException() {
            Observer w = (Observer)Mockito.mock(Observer.class);
            TestObservable w1 = new TestObservable();
            TestObservable w2 = new TestObservable();
            Observable<String> combined = Observable.create(OperationCombineLatest.combineLatest(Observable.create(w1), Observable.create(w2), new Func2<String, String, String>(){

                @Override
                public String call(String v1, String v2) {
                    throw new RuntimeException("I don't work.");
                }
            }));
            combined.subscribe(w);
            w1.observer.onNext("first value of w1");
            w2.observer.onNext("first value of w2");
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)w, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Matchers.any());
        }

        @Test
        public void testCombineLatestDifferentLengthObservableSequences1() {
            Observer w = (Observer)Mockito.mock(Observer.class);
            TestObservable w1 = new TestObservable();
            TestObservable w2 = new TestObservable();
            TestObservable w3 = new TestObservable();
            Observable<String> combineLatestW = Observable.create(OperationCombineLatest.combineLatest(Observable.create(w1), Observable.create(w2), Observable.create(w3), this.getConcat3StringsCombineLatestFunction()));
            combineLatestW.subscribe(w);
            w1.observer.onNext("1a");
            w2.observer.onNext("2a");
            w3.observer.onNext("3a");
            w1.observer.onCompleted();
            w2.observer.onNext("2b");
            w2.observer.onCompleted();
            w3.observer.onNext("3b");
            w3.observer.onNext("3c");
            w3.observer.onNext("3d");
            w3.observer.onCompleted();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{w});
            ((Observer)inOrder.verify((Object)w)).onNext("1a2a3a");
            ((Observer)inOrder.verify((Object)w)).onNext("1a2b3a");
            ((Observer)inOrder.verify((Object)w)).onNext("1a2b3b");
            ((Observer)inOrder.verify((Object)w)).onNext("1a2b3c");
            ((Observer)inOrder.verify((Object)w)).onNext("1a2b3d");
            ((Observer)inOrder.verify((Object)w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)inOrder.verify((Object)w, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testCombineLatestDifferentLengthObservableSequences2() {
            Observer w = (Observer)Mockito.mock(Observer.class);
            TestObservable w1 = new TestObservable();
            TestObservable w2 = new TestObservable();
            TestObservable w3 = new TestObservable();
            Observable<String> combineLatestW = Observable.create(OperationCombineLatest.combineLatest(Observable.create(w1), Observable.create(w2), Observable.create(w3), this.getConcat3StringsCombineLatestFunction()));
            combineLatestW.subscribe(w);
            w1.observer.onNext("1a");
            w1.observer.onNext("1b");
            w1.observer.onNext("1c");
            w1.observer.onNext("1d");
            w1.observer.onCompleted();
            w2.observer.onNext("2a");
            w2.observer.onNext("2b");
            w2.observer.onCompleted();
            w3.observer.onNext("3a");
            w3.observer.onCompleted();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{w});
            ((Observer)inOrder.verify((Object)w, Mockito.times((int)1))).onNext("1d2b3a");
            ((Observer)inOrder.verify((Object)w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)inOrder.verify((Object)w, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testCombineLatestWithInterleavingSequences() {
            Observer w = (Observer)Mockito.mock(Observer.class);
            TestObservable w1 = new TestObservable();
            TestObservable w2 = new TestObservable();
            TestObservable w3 = new TestObservable();
            Observable<String> combineLatestW = Observable.create(OperationCombineLatest.combineLatest(Observable.create(w1), Observable.create(w2), Observable.create(w3), this.getConcat3StringsCombineLatestFunction()));
            combineLatestW.subscribe(w);
            w1.observer.onNext("1a");
            w2.observer.onNext("2a");
            w2.observer.onNext("2b");
            w3.observer.onNext("3a");
            w1.observer.onNext("1b");
            w2.observer.onNext("2c");
            w2.observer.onNext("2d");
            w3.observer.onNext("3b");
            w1.observer.onCompleted();
            w2.observer.onCompleted();
            w3.observer.onCompleted();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{w});
            ((Observer)inOrder.verify((Object)w)).onNext("1a2b3a");
            ((Observer)inOrder.verify((Object)w)).onNext("1b2b3a");
            ((Observer)inOrder.verify((Object)w)).onNext("1b2c3a");
            ((Observer)inOrder.verify((Object)w)).onNext("1b2d3a");
            ((Observer)inOrder.verify((Object)w)).onNext("1b2d3b");
            ((Observer)inOrder.verify((Object)w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)inOrder.verify((Object)w, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAggregatorSimple() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("helloworld");
            a.next(r1, "hello ");
            a.next(r2, "again");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("hello again");
            a.complete(r1);
            a.complete(r2);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAggregatorDifferentSizedResultsWithOnComplete() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            a.complete(r2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("helloworld");
            a.next(r1, "hi");
            a.complete(r1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("hiworld");
        }

        @Test
        public void testAggregateMultipleTypes() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            a.complete(r2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("helloworld");
            a.next(r1, "hi");
            a.complete(r1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("hiworld");
        }

        @Test
        public void testAggregate3Types() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r3 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.addObserver(r3);
            a.next(r1, "hello");
            a.next(r2, 2);
            a.next(r3, new int[]{5, 6, 7});
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("hello2[5, 6, 7]");
        }

        @Test
        public void testAggregatorsWithDifferentSizesAndTiming() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.next(r1, "one");
            a.next(r1, "two");
            a.next(r1, "three");
            a.next(r2, "A");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("threeA");
            a.next(r1, "four");
            a.complete(r1);
            a.next(r2, "B");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("fourB");
            a.next(r2, "C");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("fourC");
            a.next(r2, "D");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("fourD");
            a.next(r2, "E");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("fourE");
            a.complete(r2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAggregatorError() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("helloworld");
            a.error(new RuntimeException(""));
            a.next(r1, "hello");
            a.next(r2, "again");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onNext("helloagain");
        }

        @Test
        public void testAggregatorUnsubscribe() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Subscription subscription = Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("helloworld");
            subscription.unsubscribe();
            a.next(r1, "hello");
            a.next(r2, "again");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onNext("helloagain");
        }

        @Test
        public void testAggregatorEarlyCompletion() {
            FuncN<String> combineLatestFunction = this.getConcatCombineLatestFunction();
            Aggregator<String> a = new Aggregator<String>(combineLatestFunction);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable.create(a).subscribe(aObserver);
            CombineObserver r1 = (CombineObserver)Mockito.mock(CombineObserver.class);
            CombineObserver r2 = (CombineObserver)Mockito.mock(CombineObserver.class);
            a.addObserver(r1);
            a.addObserver(r2);
            a.next(r1, "one");
            a.next(r1, "two");
            a.complete(r1);
            a.next(r2, "A");
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("twoA");
            a.complete(r2);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext(Mockito.anyString());
        }

        @Test
        public void testCombineLatest2Types() {
            Func2<String, Integer, String> combineLatestFunction = this.getConcatStringIntegerCombineLatestFunction();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<String> w = Observable.create(OperationCombineLatest.combineLatest(Observable.from("one", "two"), Observable.from(2, Integer.valueOf(3), 4), combineLatestFunction));
            w.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two2");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two3");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two4");
        }

        @Test
        public void testCombineLatest3TypesA() {
            Func3<String, Integer, int[], String> combineLatestFunction = this.getConcatStringIntegerIntArrayCombineLatestFunction();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<String> w = Observable.create(OperationCombineLatest.combineLatest(Observable.from("one", "two"), Observable.from(2), Observable.from(new int[]{4, 5, 6}), combineLatestFunction));
            w.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two2[4, 5, 6]");
        }

        @Test
        public void testCombineLatest3TypesB() {
            Func3<String, Integer, int[], String> combineLatestFunction = this.getConcatStringIntegerIntArrayCombineLatestFunction();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<String> w = Observable.create(OperationCombineLatest.combineLatest(Observable.from("one"), Observable.from(2), Observable.from(new int[]{4, 5, 6}, new int[]{7, 8}), combineLatestFunction));
            w.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one2[4, 5, 6]");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one2[7, 8]");
        }

        private Func3<String, String, String, String> getConcat3StringsCombineLatestFunction() {
            Func3<String, String, String, String> combineLatestFunction = new Func3<String, String, String, String>(){

                @Override
                public String call(String a1, String a2, String a3) {
                    if (a1 == null) {
                        a1 = "";
                    }
                    if (a2 == null) {
                        a2 = "";
                    }
                    if (a3 == null) {
                        a3 = "";
                    }
                    return a1 + a2 + a3;
                }
            };
            return combineLatestFunction;
        }

        private FuncN<String> getConcatCombineLatestFunction() {
            FuncN<String> combineLatestFunction = new FuncN<String>(){

                @Override
                public String call(Object ... args) {
                    String returnValue = "";
                    for (Object o : args) {
                        if (o == null) continue;
                        returnValue = returnValue + UnitTest.getStringValue(o);
                    }
                    System.out.println("returning: " + returnValue);
                    return returnValue;
                }
            };
            return combineLatestFunction;
        }

        private Func2<String, Integer, String> getConcatStringIntegerCombineLatestFunction() {
            Func2<String, Integer, String> combineLatestFunction = new Func2<String, Integer, String>(){

                @Override
                public String call(String s, Integer i) {
                    return UnitTest.getStringValue(s) + UnitTest.getStringValue(i);
                }
            };
            return combineLatestFunction;
        }

        private Func3<String, Integer, int[], String> getConcatStringIntegerIntArrayCombineLatestFunction() {
            Func3<String, Integer, int[], String> combineLatestFunction = new Func3<String, Integer, int[], String>(){

                @Override
                public String call(String s, Integer i, int[] iArray) {
                    return UnitTest.getStringValue(s) + UnitTest.getStringValue(i) + UnitTest.getStringValue(iArray);
                }
            };
            return combineLatestFunction;
        }

        private static String getStringValue(Object o) {
            if (o == null) {
                return "";
            }
            if (o instanceof int[]) {
                return Arrays.toString((int[])o);
            }
            return String.valueOf(o);
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            Observer<? super String> observer;

            private TestObservable() {
            }

            @Override
            public Subscription onSubscribe(Observer<? super String> observer) {
                this.observer = observer;
                return Subscriptions.empty();
            }
        }
    }

    private static class Aggregator<R>
    implements Observable.OnSubscribeFunc<R> {
        private volatile Observer<R> observer;
        private final FuncN<? extends R> combineLatestFunction;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final AtomicInteger numCompleted = new AtomicInteger(0);
        private final Map<CombineObserver<? extends R, ?>, Object> latestValue = new ConcurrentHashMap();
        private final List<CombineObserver<R, ?>> observers = new LinkedList();

        public Aggregator(FuncN<? extends R> combineLatestFunction) {
            this.combineLatestFunction = combineLatestFunction;
        }

        <T> void addObserver(CombineObserver<R, T> w) {
            this.observers.add(w);
        }

        <T> void complete(CombineObserver<? extends R, T> w) {
            int completed = this.numCompleted.incrementAndGet();
            if (completed == this.observers.size() && this.running.get()) {
                this.observer.onCompleted();
                this.running.set(false);
            }
        }

        void error(Throwable e) {
            this.observer.onError(e);
            this.stop();
        }

        <T> void next(CombineObserver<? extends R, T> w, T arg) {
            if (this.observer == null) {
                throw new RuntimeException("This shouldn't be running if an Observer isn't registered");
            }
            if (!this.running.get()) {
                return;
            }
            this.latestValue.put(w, arg);
            if (this.latestValue.size() < this.observers.size()) {
                return;
            }
            Object[] argsToCombineLatest = new Object[this.observers.size()];
            int i = 0;
            for (CombineObserver<R, ?> _w : this.observers) {
                argsToCombineLatest[i++] = this.latestValue.get(_w);
            }
            try {
                R combinedValue = this.combineLatestFunction.call(argsToCombineLatest);
                this.observer.onNext(combinedValue);
            }
            catch (Throwable ex) {
                this.observer.onError(ex);
            }
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> observer) {
            if (this.observer != null) {
                throw new IllegalStateException("Only one Observer can subscribe to this Observable.");
            }
            SafeObservableSubscription subscription = new SafeObservableSubscription(new Subscription(){

                @Override
                public void unsubscribe() {
                    Aggregator.this.stop();
                }
            });
            this.observer = new SynchronizedObserver<R>(observer, subscription);
            for (CombineObserver<R, ?> rw : this.observers) {
                ((CombineObserver)rw).startWatching();
            }
            return subscription;
        }

        private void stop() {
            this.running.set(false);
            for (CombineObserver<R, ?> rw : this.observers) {
                if (((CombineObserver)rw).subscription == null) continue;
                ((CombineObserver)rw).subscription.unsubscribe();
            }
        }
    }

    private static class CombineObserver<R, T>
    implements Observer<T> {
        final Observable<? extends T> w;
        final Aggregator<R> a;
        private Subscription subscription;

        public CombineObserver(Aggregator<R> a, Observable<? extends T> w) {
            this.a = a;
            this.w = w;
        }

        private void startWatching() {
            if (this.subscription != null) {
                throw new RuntimeException("This should only be called once.");
            }
            this.subscription = this.w.subscribe(this);
        }

        @Override
        public void onCompleted() {
            this.a.complete(this);
        }

        @Override
        public void onError(Throwable e) {
            this.a.error(e);
        }

        @Override
        public void onNext(T args) {
            this.a.next(this, args);
        }
    }
}

