/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func0;

public final class OperationDefer {
    public static <T> Observable.OnSubscribeFunc<T> defer(final Func0<? extends Observable<? extends T>> observableFactory) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                Observable obs = (Observable)observableFactory.call();
                return obs.subscribe(observer);
            }
        };
    }

    public static class UnitTest {
        @Test
        public void testDefer() throws Throwable {
            Func0 factory = (Func0)Mockito.mock(Func0.class);
            Observable<String> firstObservable = Observable.from("one", "two");
            Observable<String> secondObservable = Observable.from("three", "four");
            Mockito.when(factory.call()).thenReturn(firstObservable, (Object[])new Observable[]{secondObservable});
            Observable deferred = Observable.defer(factory);
            Mockito.verifyZeroInteractions((Object[])new Object[]{factory});
            Observer firstObserver = (Observer)Mockito.mock(Observer.class);
            deferred.subscribe(firstObserver);
            ((Func0)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).call();
            ((Observer)Mockito.verify((Object)firstObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)firstObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)firstObserver, (VerificationMode)Mockito.times((int)0))).onNext("three");
            ((Observer)Mockito.verify((Object)firstObserver, (VerificationMode)Mockito.times((int)0))).onNext("four");
            ((Observer)Mockito.verify((Object)firstObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            Observer secondObserver = (Observer)Mockito.mock(Observer.class);
            deferred.subscribe(secondObserver);
            ((Func0)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)2))).call();
            ((Observer)Mockito.verify((Object)secondObserver, (VerificationMode)Mockito.times((int)0))).onNext("one");
            ((Observer)Mockito.verify((Object)secondObserver, (VerificationMode)Mockito.times((int)0))).onNext("two");
            ((Observer)Mockito.verify((Object)secondObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify((Object)secondObserver, (VerificationMode)Mockito.times((int)1))).onNext("four");
            ((Observer)Mockito.verify((Object)secondObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }
}

