/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.util.functions.Func2;

public final class OperationSum {
    public static Observable<Integer> sum(Observable<Integer> source) {
        return source.reduce(0, new Func2<Integer, Integer, Integer>(){

            @Override
            public Integer call(Integer accu, Integer next) {
                return accu + next;
            }
        });
    }

    public static Observable<Long> sumLongs(Observable<Long> source) {
        return source.reduce(0L, new Func2<Long, Long, Long>(){

            @Override
            public Long call(Long accu, Long next) {
                return accu + next;
            }
        });
    }

    public static Observable<Float> sumFloats(Observable<Float> source) {
        return source.reduce(Float.valueOf(0.0f), new Func2<Float, Float, Float>(){

            @Override
            public Float call(Float accu, Float next) {
                return Float.valueOf(accu.floatValue() + next.floatValue());
            }
        });
    }

    public static Observable<Double> sumDoubles(Observable<Double> source) {
        return source.reduce(0.0, new Func2<Double, Double, Double>(){

            @Override
            public Double call(Double accu, Double next) {
                return accu + next;
            }
        });
    }

    public static class UnitTest {
        Observer<Integer> w = (Observer)Mockito.mock(Observer.class);
        Observer<Long> wl = (Observer)Mockito.mock(Observer.class);
        Observer<Float> wf = (Observer)Mockito.mock(Observer.class);
        Observer<Double> wd = (Observer)Mockito.mock(Observer.class);

        @Test
        public void testSumOfAFewInts() throws Throwable {
            Observable<Integer> src = Observable.from(1, 2, 3, 4, 5);
            OperationSum.sum(src).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify(this.w)).onNext(15);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptySum() throws Throwable {
            Observable<Integer> src = Observable.empty();
            OperationSum.sum(src).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify(this.w)).onNext(0);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSumOfAFewLongs() throws Throwable {
            Observable<Long> src = Observable.from(1L, 2L, 3L, 4L, 5L);
            OperationSum.sumLongs(src).subscribe(this.wl);
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyLong());
            ((Observer)Mockito.verify(this.wl)).onNext(15L);
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptySumLongs() throws Throwable {
            Observable<Long> src = Observable.empty();
            OperationSum.sumLongs(src).subscribe(this.wl);
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyLong());
            ((Observer)Mockito.verify(this.wl)).onNext(0L);
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSumOfAFewFloats() throws Throwable {
            Observable<Float> src = Observable.from(Float.valueOf(1.0f));
            OperationSum.sumFloats(src).subscribe(this.wf);
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.times((int)1))).onNext(Float.valueOf(Mockito.anyFloat()));
            ((Observer)Mockito.verify(this.wf)).onNext(Float.valueOf(1.0f));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptySumFloats() throws Throwable {
            Observable<Float> src = Observable.empty();
            OperationSum.sumFloats(src).subscribe(this.wf);
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.times((int)1))).onNext(Float.valueOf(Mockito.anyFloat()));
            ((Observer)Mockito.verify(this.wf)).onNext(Float.valueOf(0.0f));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSumOfAFewDoubles() throws Throwable {
            Observable<Double> src = Observable.from(0.0, 1.0, 0.5);
            OperationSum.sumDoubles(src).subscribe(this.wd);
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyDouble());
            ((Observer)Mockito.verify(this.wd)).onNext(1.5);
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptySumDoubles() throws Throwable {
            Observable<Double> src = Observable.empty();
            OperationSum.sumDoubles(src).subscribe(this.wd);
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyDouble());
            ((Observer)Mockito.verify(this.wd)).onNext(0.0);
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }
}

