/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.subjects.PublishSubject;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationTakeWhile {
    public static <T> Observable.OnSubscribeFunc<T> takeWhile(Observable<? extends T> items, Func1<? super T, Boolean> predicate) {
        return OperationTakeWhile.takeWhileWithIndex(items, OperationTakeWhile.skipIndex(predicate));
    }

    public static <T> Observable.OnSubscribeFunc<T> takeWhileWithIndex(final Observable<? extends T> items, final Func2<? super T, ? super Integer, Boolean> predicate) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new TakeWhile(items, predicate).onSubscribe(observer);
            }
        };
    }

    private static <T> Func2<T, Integer, Boolean> skipIndex(final Func1<? super T, Boolean> underlying) {
        return new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T input, Integer index) {
                return (Boolean)underlying.call(input);
            }
        };
    }

    public static class UnitTest {
        @Test
        public void testTakeWhile1() {
            Observable<Integer> w = Observable.from(1, Integer.valueOf(2), 3);
            Observable<Integer> take = Observable.create(OperationTakeWhile.takeWhile(w, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer input) {
                    return input < 3;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(3);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeWhileOnSubject1() {
            PublishSubject<Integer> s = PublishSubject.create();
            Observable<Integer> take = Observable.create(OperationTakeWhile.takeWhile(s, new Func1<Integer, Boolean>(){

                @Override
                public Boolean call(Integer input) {
                    return input < 3;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            s.onNext(1);
            s.onNext(2);
            s.onNext(3);
            s.onNext(4);
            s.onNext(5);
            s.onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(3);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(4);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(5);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeWhile2() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<String> take = Observable.create(OperationTakeWhile.takeWhileWithIndex(w, new Func2<String, Integer, Boolean>(){

                @Override
                public Boolean call(String input, Integer index) {
                    return index < 2;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeWhileDoesntLeakErrors() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    observer.onNext("one");
                    observer.onError(new Throwable("test failed"));
                    return Subscriptions.empty();
                }
            });
            Observable.create(OperationTakeWhile.takeWhile(source, new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    return false;
                }
            })).toBlockingObservable().last();
        }

        @Test
        public void testTakeWhileProtectsPredicateCall() {
            TestObservable source = new TestObservable((Subscription)Mockito.mock(Subscription.class), "one");
            final RuntimeException testException = new RuntimeException("test exception");
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<String> take = Observable.create(OperationTakeWhile.takeWhile(Observable.create(source), new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    throw testException;
                }
            }));
            take.subscribe(aObserver);
            try {
                source.t.join();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(Mockito.any(String.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError(testException);
        }

        @Test
        public void testUnsubscribeAfterTake() {
            Subscription s = (Subscription)Mockito.mock(Subscription.class);
            TestObservable w = new TestObservable(s, "one", "two", "three");
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<String> take = Observable.create(OperationTakeWhile.takeWhileWithIndex(Observable.create(w), new Func2<String, Integer, Boolean>(){

                @Override
                public Boolean call(String s, Integer index) {
                    return index < 1;
                }
            }));
            take.subscribe(aObserver);
            try {
                w.t.join();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            System.out.println("TestObservable thread finished");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Subscription)Mockito.verify((Object)s, (VerificationMode)Mockito.times((int)1))).unsubscribe();
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            final Subscription s;
            final String[] values;
            Thread t = null;

            public TestObservable(Subscription s, String ... values) {
                this.s = s;
                this.values = values;
            }

            @Override
            public Subscription onSubscribe(final Observer<? super String> observer) {
                System.out.println("TestObservable subscribed to ...");
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            System.out.println("running TestObservable thread");
                            for (String s : TestObservable.this.values) {
                                System.out.println("TestObservable onNext: " + s);
                                observer.onNext(s);
                            }
                            observer.onCompleted();
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                System.out.println("starting TestObservable thread");
                this.t.start();
                System.out.println("done starting TestObservable thread");
                return this.s;
            }
        }
    }

    private static class TakeWhile<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> items;
        private final Func2<? super T, ? super Integer, Boolean> predicate;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();

        private TakeWhile(Observable<? extends T> items, Func2<? super T, ? super Integer, Boolean> predicate) {
            this.items = items;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.subscription.wrap(this.items.subscribe(new ItemObserver(observer)));
        }

        private class ItemObserver
        implements Observer<T> {
            private final Observer<? super T> observer;
            private final AtomicInteger counter = new AtomicInteger();

            public ItemObserver(Observer<? super T> observer) {
                this.observer = new SafeObserver(TakeWhile.this.subscription, observer);
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T args) {
                Boolean isSelected;
                try {
                    isSelected = (Boolean)TakeWhile.this.predicate.call(args, this.counter.getAndIncrement());
                }
                catch (Throwable e) {
                    this.observer.onError(e);
                    return;
                }
                if (isSelected.booleanValue()) {
                    this.observer.onNext(args);
                } else {
                    this.observer.onCompleted();
                    TakeWhile.this.subscription.unsubscribe();
                }
            }
        }
    }
}

