/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SynchronizedObserver;
import rx.util.functions.Func2;
import rx.util.functions.Func3;
import rx.util.functions.Func4;
import rx.util.functions.Func5;
import rx.util.functions.Func6;
import rx.util.functions.Func7;
import rx.util.functions.Func8;
import rx.util.functions.Func9;
import rx.util.functions.FuncN;
import rx.util.functions.Functions;

public class OperationCombineLatest {
    public static <T0, T1, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<T1> w1, Func2<? super T0, ? super T1, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        return a;
    }

    public static <T0, T1, T2, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Func3<? super T0, ? super T1, ? super T2, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        return a;
    }

    public static <T0, T1, T2, T3, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Func4<? super T0, ? super T1, ? super T2, ? super T3, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        return a;
    }

    public static <T0, T1, T2, T3, T4, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Func5<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Func6<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, T6, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Func7<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        a.addObserver(new CombineObserver<R, T6>(a, w6));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Observable<? extends T7> w7, Func8<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        a.addObserver(new CombineObserver<R, T6>(a, w6));
        a.addObserver(new CombineObserver<R, T7>(a, w7));
        return a;
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Observable<? extends T7> w7, Observable<? extends T8> w8, Func9<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combineLatestFunction) {
        Aggregator<Object> a = new Aggregator<Object>(Functions.fromFunc(combineLatestFunction));
        a.addObserver(new CombineObserver<R, T0>(a, w0));
        a.addObserver(new CombineObserver<R, T1>(a, w1));
        a.addObserver(new CombineObserver<R, T2>(a, w2));
        a.addObserver(new CombineObserver<R, T3>(a, w3));
        a.addObserver(new CombineObserver<R, T4>(a, w4));
        a.addObserver(new CombineObserver<R, T5>(a, w5));
        a.addObserver(new CombineObserver<R, T6>(a, w6));
        a.addObserver(new CombineObserver<R, T7>(a, w7));
        a.addObserver(new CombineObserver<R, T8>(a, w8));
        return a;
    }

    static class Aggregator<R>
    implements Observable.OnSubscribeFunc<R> {
        private volatile Observer<R> observer;
        private final FuncN<? extends R> combineLatestFunction;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final AtomicInteger numCompleted = new AtomicInteger(0);
        private final Map<CombineObserver<? extends R, ?>, Object> latestValue = new ConcurrentHashMap();
        private final List<CombineObserver<R, ?>> observers = new LinkedList();

        public Aggregator(FuncN<? extends R> combineLatestFunction) {
            this.combineLatestFunction = combineLatestFunction;
        }

        <T> void addObserver(CombineObserver<R, T> w) {
            this.observers.add(w);
        }

        <T> void complete(CombineObserver<? extends R, T> w) {
            int completed = this.numCompleted.incrementAndGet();
            if (completed == this.observers.size() && this.running.get()) {
                this.observer.onCompleted();
                this.running.set(false);
            }
        }

        void error(Throwable e) {
            this.observer.onError(e);
            this.stop();
        }

        <T> void next(CombineObserver<? extends R, T> w, T arg) {
            if (this.observer == null) {
                throw new RuntimeException("This shouldn't be running if an Observer isn't registered");
            }
            if (!this.running.get()) {
                return;
            }
            this.latestValue.put(w, arg);
            if (this.latestValue.size() < this.observers.size()) {
                return;
            }
            Object[] argsToCombineLatest = new Object[this.observers.size()];
            int i = 0;
            for (CombineObserver<R, ?> _w : this.observers) {
                argsToCombineLatest[i++] = this.latestValue.get(_w);
            }
            try {
                R combinedValue = this.combineLatestFunction.call(argsToCombineLatest);
                this.observer.onNext(combinedValue);
            }
            catch (Throwable ex) {
                this.observer.onError(ex);
            }
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> observer) {
            if (this.observer != null) {
                throw new IllegalStateException("Only one Observer can subscribe to this Observable.");
            }
            SafeObservableSubscription subscription = new SafeObservableSubscription(new Subscription(){

                @Override
                public void unsubscribe() {
                    Aggregator.this.stop();
                }
            });
            this.observer = new SynchronizedObserver<R>(observer, subscription);
            for (CombineObserver<R, ?> rw : this.observers) {
                ((CombineObserver)rw).startWatching();
            }
            return subscription;
        }

        private void stop() {
            this.running.set(false);
            for (CombineObserver<R, ?> rw : this.observers) {
                if (((CombineObserver)rw).subscription == null) continue;
                ((CombineObserver)rw).subscription.unsubscribe();
            }
        }
    }

    static class CombineObserver<R, T>
    implements Observer<T> {
        final Observable<? extends T> w;
        final Aggregator<R> a;
        private Subscription subscription;

        public CombineObserver(Aggregator<R> a, Observable<? extends T> w) {
            this.a = a;
            this.w = w;
        }

        private void startWatching() {
            if (this.subscription != null) {
                throw new RuntimeException("This should only be called once.");
            }
            this.subscription = this.w.subscribe(this);
        }

        @Override
        public void onCompleted() {
            this.a.complete(this);
        }

        @Override
        public void onError(Throwable e) {
            this.a.error(e);
        }

        @Override
        public void onNext(T args) {
            this.a.next(this, args);
        }
    }
}

