/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.Future;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.util.functions.Action0;

public class Subscriptions {
    private static Subscription EMPTY = new Subscription(){

        @Override
        public void unsubscribe() {
        }
    };

    public static Subscription empty() {
        return EMPTY;
    }

    public static Subscription create(final Action0 unsubscribe) {
        return new SafeObservableSubscription(new Subscription(){

            @Override
            public void unsubscribe() {
                unsubscribe.call();
            }
        });
    }

    public static Subscription from(final Future<?> f) {
        return new Subscription(){

            @Override
            public void unsubscribe() {
                f.cancel(true);
            }
        };
    }

    public static Subscription create(final Future<?> f) {
        return new Subscription(){

            @Override
            public void unsubscribe() {
                f.cancel(true);
            }
        };
    }

    public static CompositeSubscription from(Subscription ... subscriptions) {
        return new CompositeSubscription(subscriptions);
    }

    public static CompositeSubscription create(Subscription ... subscriptions) {
        return new CompositeSubscription(subscriptions);
    }
}

