/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public final class OperationConcat {
    public static <T> Observable.OnSubscribeFunc<T> concat(Observable<? extends T> ... sequences) {
        return OperationConcat.concat(Observable.from(sequences));
    }

    public static <T> Observable.OnSubscribeFunc<T> concat(Iterable<? extends Observable<? extends T>> sequences) {
        return OperationConcat.concat(Observable.from(sequences));
    }

    public static <T> Observable.OnSubscribeFunc<T> concat(Observable<? extends Observable<? extends T>> sequences) {
        return new Concat(sequences);
    }

    private static class Concat<T>
    implements Observable.OnSubscribeFunc<T> {
        private Observable<? extends Observable<? extends T>> sequences;
        private SafeObservableSubscription innerSubscription = null;

        public Concat(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final AtomicBoolean completedOrErred = new AtomicBoolean(false);
            final AtomicBoolean allSequencesReceived = new AtomicBoolean(false);
            final ConcurrentLinkedQueue nextSequences = new ConcurrentLinkedQueue();
            final SafeObservableSubscription outerSubscription = new SafeObservableSubscription();
            final Observer reusableObserver = new Observer<T>(){

                @Override
                public void onNext(T item) {
                    observer.onNext(item);
                }

                @Override
                public void onError(Throwable e) {
                    if (completedOrErred.compareAndSet(false, true)) {
                        outerSubscription.unsubscribe();
                        observer.onError(e);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted() {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (nextSequences.isEmpty()) {
                            Concat.this.innerSubscription = null;
                            if (allSequencesReceived.get() && completedOrErred.compareAndSet(false, true)) {
                                observer.onCompleted();
                            }
                        } else {
                            Concat.this.innerSubscription = new SafeObservableSubscription();
                            Concat.this.innerSubscription.wrap(((Observable)nextSequences.poll()).subscribe(this));
                        }
                    }
                }
            };
            outerSubscription.wrap(this.sequences.subscribe(new Observer<Observable<? extends T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(Observable<? extends T> nextSequence) {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (Concat.this.innerSubscription == null) {
                            Concat.this.innerSubscription = new SafeObservableSubscription();
                            Concat.this.innerSubscription.wrap(nextSequence.subscribe(reusableObserver));
                        } else {
                            nextSequences.add(nextSequence);
                        }
                    }
                }

                @Override
                public void onError(Throwable e) {
                    if (completedOrErred.compareAndSet(false, true)) {
                        if (Concat.this.innerSubscription != null) {
                            Concat.this.innerSubscription.unsubscribe();
                        }
                        observer.onError(e);
                    }
                }

                @Override
                public void onCompleted() {
                    allSequencesReceived.set(true);
                    if (Concat.this.innerSubscription == null && completedOrErred.compareAndSet(false, true)) {
                        observer.onCompleted();
                    }
                }
            }));
            return new Subscription(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void unsubscribe() {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (Concat.this.innerSubscription != null) {
                            Concat.this.innerSubscription.unsubscribe();
                        }
                        outerSubscription.unsubscribe();
                    }
                }
            };
        }
    }
}

