/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.ImmediateScheduler;
import rx.operators.ScheduledObserver;
import rx.subscriptions.CompositeSubscription;

public class OperationObserveOn {
    public static <T> Observable.OnSubscribeFunc<T> observeOn(Observable<? extends T> source, Scheduler scheduler) {
        return new ObserveOn<T>(source, scheduler);
    }

    private static class ObserveOn<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Scheduler scheduler;

        public ObserveOn(Observable<? extends T> source, Scheduler scheduler) {
            this.source = source;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            if (this.scheduler instanceof ImmediateScheduler) {
                return this.source.subscribe(observer);
            }
            CompositeSubscription s = new CompositeSubscription(new Subscription[0]);
            s.add(this.source.subscribe(new ScheduledObserver<T>(s, observer, this.scheduler)));
            return s;
        }
    }
}

