/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SynchronizedObserver;

public final class OperationSynchronize<T> {
    public static <T> Observable.OnSubscribeFunc<T> synchronize(Observable<? extends T> observable) {
        return new Synchronize<T>(observable, null);
    }

    public static <T> Observable.OnSubscribeFunc<T> synchronize(Observable<? extends T> observable, Object lock) {
        return new Synchronize<T>(observable, lock);
    }

    private static class Synchronize<T>
    implements Observable.OnSubscribeFunc<T> {
        private Observable<? extends T> innerObservable;
        private SynchronizedObserver<T> atomicObserver;
        private Object lock;

        public Synchronize(Observable<? extends T> innerObservable, Object lock) {
            this.innerObservable = innerObservable;
            this.lock = lock;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            this.atomicObserver = this.lock == null ? new SynchronizedObserver<T>(observer, subscription) : new SynchronizedObserver<T>(observer, subscription, this.lock);
            return subscription.wrap(this.innerObservable.subscribe(this.atomicObserver));
        }
    }
}

