/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.Subscriptions;

public final class OperationTake {
    public static <T> Observable.OnSubscribeFunc<T> take(final Observable<? extends T> items, final int num) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Take(items, num).onSubscribe(observer);
            }
        };
    }

    private static class Take<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> items;
        private final int num;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();

        private Take(Observable<? extends T> items, int num) {
            this.items = items;
            this.num = num;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            if (this.num < 1) {
                this.items.subscribe(new Observer<T>(){

                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                    }

                    @Override
                    public void onNext(T args) {
                    }
                }).unsubscribe();
                observer.onCompleted();
                return Subscriptions.empty();
            }
            return this.subscription.wrap(this.items.subscribe(new ItemObserver(observer)));
        }

        private class ItemObserver
        implements Observer<T> {
            private final Observer<? super T> observer;
            private final AtomicInteger counter = new AtomicInteger();
            private volatile boolean hasEmitedError = false;

            public ItemObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                if (this.hasEmitedError) {
                    return;
                }
                if (this.counter.getAndSet(Take.this.num) < Take.this.num) {
                    this.observer.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (this.hasEmitedError) {
                    return;
                }
                if (this.counter.getAndSet(Take.this.num) < Take.this.num) {
                    this.observer.onError(e);
                }
            }

            @Override
            public void onNext(T args) {
                if (this.hasEmitedError) {
                    return;
                }
                int count = this.counter.incrementAndGet();
                if (count <= Take.this.num) {
                    try {
                        this.observer.onNext(args);
                    }
                    catch (Throwable ex) {
                        this.hasEmitedError = true;
                        this.observer.onError(ex);
                        Take.this.subscription.unsubscribe();
                        return;
                    }
                    if (count == Take.this.num) {
                        this.observer.onCompleted();
                    }
                }
                if (count >= Take.this.num) {
                    Take.this.subscription.unsubscribe();
                }
            }
        }
    }
}

