/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import com.netflix.servo.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class UnmodifiableList {
    private UnmodifiableList() {
    }

    public static <E> List<E> of(E ... elements) {
        Preconditions.checkNotNull(elements, "elements");
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static <E> List<E> copyOf(E[] elements) {
        Preconditions.checkNotNull(elements, "elements");
        ArrayList result = new ArrayList(elements.length);
        Collections.addAll(result, elements);
        return Collections.unmodifiableList(result);
    }

    static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    public static <E> List<E> copyOf(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements, "elements");
        ArrayList<E> result = elements instanceof Collection ? new ArrayList<E>(UnmodifiableList.cast(elements).size()) : new ArrayList();
        for (E e : elements) {
            result.add(e);
        }
        return Collections.unmodifiableList(result);
    }
}

