/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.AtomicUtils;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLongArray;

public class MinGauge
extends AbstractMonitor<Long>
implements Gauge<Long>,
ResettableMonitor<Long> {
    private final AtomicLongArray min = new AtomicLongArray(Pollers.NUM_POLLERS);

    public MinGauge(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        for (int i = 0; i < this.min.length(); ++i) {
            this.min.set(i, Long.MAX_VALUE);
        }
    }

    private void updateMin(int idx, long v) {
        long currentMinValue = this.min.get(idx);
        while (v < currentMinValue && !this.min.compareAndSet(idx, currentMinValue, v)) {
            currentMinValue = this.min.get(idx);
        }
    }

    public void update(long v) {
        for (int i = 0; i < this.min.length(); ++i) {
            this.updateMin(i, v);
        }
    }

    @Override
    public Long getValue() {
        long v = this.min.get(0);
        return v == Long.MAX_VALUE ? 0L : v;
    }

    @Override
    public Long getAndResetValue() {
        return this.getAndResetValue(0);
    }

    @Override
    public Long getAndResetValue(int pollerIdx) {
        long v = this.min.getAndSet(pollerIdx, Long.MAX_VALUE);
        return v == Long.MAX_VALUE ? 0L : v;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MinGauge)) {
            return false;
        }
        MinGauge m = (MinGauge)obj;
        return this.config.equals(m.getConfig()) && AtomicUtils.equals(this.min, m.min);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, AtomicUtils.hashCode(this.min)});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("min", (Object)this.min).toString();
    }
}

