/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetricPoller
implements MetricPoller {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract List<Metric> pollImpl(boolean var1);

    @Override
    public final List<Metric> poll(MetricFilter filter) {
        return this.poll(filter, false);
    }

    @Override
    public final List<Metric> poll(MetricFilter filter, boolean reset) {
        Preconditions.checkNotNull((Object)filter, (Object)"filter cannot be null");
        List<Metric> metrics = this.pollImpl(reset);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Metric m : metrics) {
            if (!filter.matches(m.getConfig())) continue;
            builder.add((Object)m);
        }
        ImmutableList retainedMetrics = builder.build();
        this.logger.debug("received {} metrics, retained {} metrics", (Object)metrics.size(), (Object)retainedMetrics.size());
        return retainedMetrics;
    }
}

