/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Collector;
import com.networknt.schema.ThreadInfo;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CollectorContext {
    static final String COLLECTOR_CONTEXT_THREAD_LOCAL_KEY = "com.networknt.schema.CollectorKey";
    private Map<String, Object> collectorMap = new HashMap<String, Object>();
    private Map<String, Object> collectorLoadMap = new HashMap<String, Object>();
    private final Deque<Scope> dynamicScopes = new LinkedList<Scope>();
    private final boolean disableUnevaluatedItems;
    private final boolean disableUnevaluatedProperties;

    public static CollectorContext getInstance() {
        return (CollectorContext)ThreadInfo.get(COLLECTOR_CONTEXT_THREAD_LOCAL_KEY);
    }

    public CollectorContext() {
        this(false, false);
    }

    public CollectorContext(boolean disableUnevaluatedItems, boolean disableUnevaluatedProperties) {
        this.disableUnevaluatedItems = disableUnevaluatedItems;
        this.disableUnevaluatedProperties = disableUnevaluatedProperties;
        this.dynamicScopes.push(this.newTopScope());
    }

    public Scope enterDynamicScope() {
        Scope parent = this.dynamicScopes.peek();
        this.dynamicScopes.push(this.newScope());
        return parent;
    }

    public Scope exitDynamicScope() {
        return this.dynamicScopes.pop();
    }

    public Scope getDynamicScope() {
        return this.dynamicScopes.peek();
    }

    public Collection<String> getEvaluatedItems() {
        return this.getDynamicScope().getEvaluatedItems();
    }

    public Collection<String> getEvaluatedProperties() {
        return this.getDynamicScope().getEvaluatedProperties();
    }

    public <E> void add(String name, Collector<E> collector) {
        this.collectorMap.put(name, collector);
    }

    public <E> void add(String name, Object object) {
        this.collectorMap.put(name, object);
    }

    public Object get(String name) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector && this.collectorLoadMap.get(name) != null) {
            return this.collectorLoadMap.get(name);
        }
        return this.collectorMap.get(name);
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        mergedMap.putAll(this.collectorMap);
        mergedMap.putAll(this.collectorLoadMap);
        return mergedMap;
    }

    public void combineWithCollector(String name, Object data) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector) {
            Collector collector = (Collector)object;
            collector.combine(data);
        }
    }

    public void reset() {
        this.collectorMap = new HashMap<String, Object>();
        this.collectorLoadMap = new HashMap<String, Object>();
        this.dynamicScopes.clear();
        this.dynamicScopes.push(this.newTopScope());
    }

    void loadCollectors() {
        Set<Map.Entry<String, Object>> entrySet = this.collectorMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!(entry.getValue() instanceof Collector)) continue;
            Collector collector = (Collector)entry.getValue();
            this.collectorLoadMap.put(entry.getKey(), collector.collect());
        }
    }

    private Scope newScope() {
        return new Scope(this.disableUnevaluatedItems, this.disableUnevaluatedProperties);
    }

    private Scope newTopScope() {
        return new Scope(true, this.disableUnevaluatedItems, this.disableUnevaluatedProperties);
    }

    public static class Scope {
        private final Collection<String> evaluatedItems;
        private final Collection<String> evaluatedProperties;
        private final boolean top;

        Scope(boolean disableUnevaluatedItems, boolean disableUnevaluatedProperties) {
            this(false, disableUnevaluatedItems, disableUnevaluatedProperties);
        }

        Scope(boolean top, boolean disableUnevaluatedItems, boolean disableUnevaluatedProperties) {
            this.top = top;
            this.evaluatedItems = Scope.newCollection(disableUnevaluatedItems);
            this.evaluatedProperties = Scope.newCollection(disableUnevaluatedProperties);
        }

        private static Collection<String> newCollection(boolean disabled) {
            return !disabled ? new ArrayList() : new AbstractCollection<String>(){

                @Override
                public boolean add(String e) {
                    return false;
                }

                @Override
                public Iterator<String> iterator() {
                    return Collections.emptyIterator();
                }

                @Override
                public boolean remove(Object o) {
                    return false;
                }

                @Override
                public int size() {
                    return 0;
                }
            };
        }

        public boolean isTop() {
            return this.top;
        }

        public Collection<String> getEvaluatedItems() {
            return this.evaluatedItems;
        }

        public Collection<String> getEvaluatedProperties() {
            return this.evaluatedProperties;
        }

        public Scope mergeWith(Scope scope) {
            this.getEvaluatedItems().addAll(scope.getEvaluatedItems());
            this.getEvaluatedProperties().addAll(scope.getEvaluatedProperties());
            return this;
        }

        public String toString() {
            return "{ " + "\"evaluatedItems\": " + this.evaluatedItems + ", " + "\"evaluatedProperties\": " + this.evaluatedProperties + " }";
        }
    }
}

