/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import com.networknt.schema.regex.RegularExpression;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternPropertiesValidator
extends BaseJsonValidator {
    public static final String PROPERTY = "patternProperties";
    private static final Logger logger = LoggerFactory.getLogger(PatternPropertiesValidator.class);
    private final Map<RegularExpression, JsonSchema> schemas = new IdentityHashMap<RegularExpression, JsonSchema>();
    private Boolean hasUnevaluatedPropertiesValidator = null;

    public PatternPropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.PATTERN_PROPERTIES, validationContext);
        if (!schemaNode.isObject()) {
            throw new JsonSchemaException("patternProperties must be an object node");
        }
        Iterator names = schemaNode.fieldNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            RegularExpression pattern = RegularExpression.compile(name, validationContext);
            this.schemas.put(pattern, validationContext.newSchema(schemaLocation.append(name), evaluationPath.append(name), schemaNode.get(name), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        boolean collectAnnotations;
        PatternPropertiesValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        if (!node.isObject()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ValidationMessage> errors = null;
        Set matchedInstancePropertyNames = null;
        Iterator names = node.fieldNames();
        boolean bl = collectAnnotations = this.collectAnnotations() || this.collectAnnotations(executionContext);
        while (names.hasNext()) {
            String name = (String)names.next();
            JsonNode n = node.get(name);
            for (Map.Entry<RegularExpression, JsonSchema> entry : this.schemas.entrySet()) {
                if (!entry.getKey().matches(name)) continue;
                JsonNodePath path = instanceLocation.append(name);
                Set<ValidationMessage> results = entry.getValue().validate(executionContext, n, rootNode, path);
                if (results.isEmpty()) {
                    if (!collectAnnotations) continue;
                    if (matchedInstancePropertyNames == null) {
                        matchedInstancePropertyNames = new LinkedHashSet();
                    }
                    matchedInstancePropertyNames.add(name);
                    continue;
                }
                if (errors == null) {
                    errors = new LinkedHashSet<ValidationMessage>();
                }
                errors.addAll(results);
            }
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames != null ? matchedInstancePropertyNames : Collections.emptySet()).build());
        }
        return errors == null ? Collections.emptySet() : Collections.unmodifiableSet(errors);
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedPropertiesValidator();
    }

    private boolean hasUnevaluatedPropertiesValidator() {
        if (this.hasUnevaluatedPropertiesValidator == null) {
            this.hasUnevaluatedPropertiesValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedProperties");
        }
        return this.hasUnevaluatedPropertiesValidator;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas.values());
        this.collectAnnotations();
    }
}

