package com.networknt.schema.dialect;

import java.util.Arrays;

import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.format.Formats;
import com.networknt.schema.keyword.AnnotationKeyword;
import com.networknt.schema.keyword.NonValidationKeyword;
import com.networknt.schema.keyword.KeywordType;

/**
 * Draft 4 dialect.
 */
public class Draft4 {
    private static final String ID = DialectId.DRAFT_4;
    private static final String ID_KEYWORD = "id";
    
    private static class Holder {
        private static final Dialect INSTANCE;
        static {
            INSTANCE = Dialect.builder(ID)
                    .specificationVersion(SpecificationVersion.DRAFT_4)
                    .idKeyword(ID_KEYWORD)
                    .formats(Formats.DEFAULT)
                    .keywords(KeywordType.getKeywords(SpecificationVersion.DRAFT_4))
                    // keywords that may validly exist, but have no validation aspect to them
                    .keywords(Arrays.asList(
                            new NonValidationKeyword("$schema"),
                            new NonValidationKeyword("id"),
                            new AnnotationKeyword("title"),
                            new AnnotationKeyword("description"),
                            new AnnotationKeyword("default"),
                            new NonValidationKeyword("definitions"),
                            new NonValidationKeyword("additionalItems"),
                            new AnnotationKeyword("exampleSetFlag"),
                            new NonValidationKeyword("exclusiveMinimum"), // exclusiveMinimum boolean handled by minimum validator
                            new NonValidationKeyword("exclusiveMaximum")  // exclusiveMaximum boolean handled by maximum validator
                    ))
                    .build(); 
        }
    }

    public static Dialect getInstance() {
        return Holder.INSTANCE;
    }
}
