/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionHolder;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.OtherRootTracer;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.TracerFlags;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TransactionStateImpl
implements TransactionState {
    private static final Pattern METRIC_NAME_REPLACE = Pattern.compile("${className}", 16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer(Transaction tx, TracerFactory tracerFactory, ClassMethodSignature sig, Object obj, Object ... args) {
        TransactionActivity activity = tx.getTransactionActivity();
        if (tx.isIgnore() || activity.isTracerStartLocked()) {
            return null;
        }
        Tracer tracer = null;
        try {
            activity.lockTracerStart();
            tracer = tracerFactory.getTracer(tx, sig, obj, args);
        }
        finally {
            activity.unlockTracerStart();
        }
        return this.tracerStarted(tx, sig, tracer);
    }

    public Tracer getTracer(Transaction tx, String tracerFactoryName, ClassMethodSignature sig, Object obj, Object ... args) {
        TracerFactory tracerFactory = ServiceFactory.getTracerService().getTracerFactory(tracerFactoryName);
        return this.getTracer(tx, tracerFactory, sig, obj, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer(Transaction tx, Object invocationTarget, ClassMethodSignature sig, String metricName, int flags) {
        DefaultTracer tracer;
        TransactionActivity activity = tx.getTransactionActivity();
        if (tx.isIgnore() || activity.isTracerStartLocked()) {
            return null;
        }
        try {
            activity.lockTracerStart();
            MetricNameFormat metricNameFormat = null == metricName ? sig.getMetricNameFormat(invocationTarget, flags) : new SimpleMetricNameFormat(TransactionStateImpl.getTracerMetricName(invocationTarget, sig.getClassName(), metricName));
            tracer = TracerFlags.isDispatcher(flags) ? new OtherRootTracer(tx, sig, invocationTarget, metricNameFormat) : new DefaultTracer(tx, sig, invocationTarget, metricNameFormat, flags);
        }
        finally {
            activity.unlockTracerStart();
        }
        return this.tracerStarted(tx, sig, tracer);
    }

    private Tracer tracerStarted(Transaction tx, ClassMethodSignature sig, Tracer tracer) {
        if (tracer == null || tracer instanceof SkipTracer) {
            return tracer;
        }
        tracer = tx.getTransactionActivity().tracerStarted(tracer);
        if (tracer != null && Agent.LOG.isLoggable(Level.FINER)) {
            if (tracer == tx.getRootTracer()) {
                Agent.LOG.log(Level.FINER, "Transaction started {0}", new Object[]{tx});
            }
            Agent.LOG.log(Level.FINER, "Tracer ({3}) Started: {0}.{1}{2}", new Object[]{sig.getClassName(), sig.getMethodName(), sig.getMethodDesc(), tracer});
        }
        return tracer;
    }

    private static String getTracerMetricName(Object invocationTarget, String className, String metricName) {
        Matcher matcher = METRIC_NAME_REPLACE.matcher(metricName);
        return matcher.replaceFirst(Matcher.quoteReplacement(invocationTarget == null ? className : invocationTarget.getClass().getName()));
    }

    public Tracer getRootTracer() {
        return null;
    }

    public void resume() {
    }

    public void suspend() {
    }

    public void complete() {
    }

    public boolean finish(Transaction tx, Tracer tracer) {
        return true;
    }

    public void suspendRootTracer() {
    }

    public void asyncJobStarted(TransactionHolder job) {
    }

    public void asyncJobFinished(TransactionHolder job) {
    }

    public void asyncTransactionStarted(Transaction tx, TransactionHolder txHolder) {
    }

    public void asyncTransactionFinished(TransactionActivity txa) {
    }

    public void mergeAsyncTracers() {
    }

    public void asyncJobInvalidate(TransactionHolder job) {
    }

    public void setInvalidateAsyncJobs(boolean invalidate) {
    }
}

