/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.JarResource;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentJarHelper {
    private static final Pattern AGENT_CLASS_PATTERN = Pattern.compile(Type.getInternalName(Agent.class) + ".class");
    private static final String NEW_RELIC_JAR_FILE = "newrelic.jar";
    private static final String BUILT_DATE_ATTRIBUTE = "Built-Date";

    public static Collection<String> findAgentJarFileNames(Pattern pattern) {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        Agent.LOG.log(Level.FINEST, "Searching for " + pattern.pattern() + " in " + agentJarUrl.getPath());
        return AgentJarHelper.findJarFileNames(agentJarUrl, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<String> findJarFileNames(URL agentJarUrl, Pattern pattern) {
        JarFile jarFile = null;
        jarFile = AgentJarHelper.getAgentJarFile(agentJarUrl);
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!pattern.matcher(jarEntry.getName()).matches()) continue;
            names.add(jarEntry.getName());
        }
        ArrayList<String> arrayList = names;
        Object var7_7 = null;
        if (jarFile == null) return arrayList;
        try {
            jarFile.close();
            return arrayList;
        }
        catch (IOException e2) {
            // empty catch block
        }
        return arrayList;
        catch (Exception e) {
            try {
                Agent.LOG.log(Level.FINEST, "Unable to search the agent jar for " + pattern.pattern(), e);
                Object var7_8 = null;
                if (jarFile == null) return Collections.emptyList();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (jarFile == null) throw throwable;
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                jarFile.close();
                return Collections.emptyList();
            }
            catch (IOException e2) {}
            return Collections.emptyList();
        }
    }

    public static File getAgentJarDirectory() {
        File file;
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        if (agentJarUrl != null && (file = new File(AgentJarHelper.getAgentJarFileName(agentJarUrl))).exists()) {
            return file.getParentFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL getAgentJarUrl() {
        if (System.getProperty("newrelic.agent_jarfile") != null) {
            try {
                return new URL("file://" + System.getProperty("newrelic.agent_jarfile"));
            }
            catch (MalformedURLException e) {
                Agent.LOG.log(Level.FINEST, "Unable to create a valid url from " + System.getProperty("newrelic.agent_jarfile"), e);
            }
        }
        if ((classLoader = ClassLoader.getSystemClassLoader()) instanceof URLClassLoader == false) return AgentJarHelper.class.getProtectionDomain().getCodeSource().getLocation();
        for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
            if (!url.getFile().endsWith("newrelic.jar") || (names = AgentJarHelper.findJarFileNames(url, AgentJarHelper.AGENT_CLASS_PATTERN)).isEmpty()) continue;
            return url;
        }
        agentClassName = Agent.class.getName().replace('.', '/') + ".class";
        arr$ = urls;
        len$ = arr$.length;
        i$ = 0;
        while (i$ < len$) {
            block18: {
                block16: {
                    url = arr$[i$];
                    jarFile = null;
                    try {
                        try {
                            jarFile = new JarFile(url.getFile());
                            entry = jarFile.getEntry(agentClassName);
                            if (entry == null) break block16;
                            var9_15 = url;
                            var11_13 = null;
                            if (jarFile == null) return var9_15;
                        }
                        catch (IOException e) {
                            var11_13 = null;
                            if (jarFile == null) break block18;
                            try {
                                jarFile.close();
                            }
                            catch (IOException e) {}
                            break block18;
                        }
                    }
                    catch (Throwable var10_16) {
                        var11_13 = null;
                        if (jarFile == null) throw var10_16;
                        ** try [egrp 3[TRYBLOCK] [6 : 278->286)] { 
lbl41:
                        // 1 sources

                        jarFile.close();
                        throw var10_16;
lbl43:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var10_16;
                    }
                    try {}
                    catch (IOException e) {
                        // empty catch block
                        return var9_15;
                    }
                    jarFile.close();
                    return var9_15;
                }
                var11_13 = null;
                if (jarFile != null) {
                    try {}
                    catch (IOException e) {}
                    jarFile.close();
                }
            }
            ++i$;
        }
        return AgentJarHelper.class.getProtectionDomain().getCodeSource().getLocation();
    }

    public static JarResource getAgentJarResource() {
        final JarFile agentJarFile = AgentJarHelper.getAgentJarFile();
        if (agentJarFile == null) {
            return new JarResource(){

                public void close() throws IOException {
                }

                public InputStream getInputStream(String name) {
                    return AgentJarHelper.class.getResourceAsStream('/' + name);
                }

                public long getSize(String name) {
                    return 128L;
                }
            };
        }
        return new JarResource(){

            public void close() throws IOException {
                agentJarFile.close();
            }

            public InputStream getInputStream(String name) throws IOException {
                JarEntry entry = agentJarFile.getJarEntry(name);
                return agentJarFile.getInputStream(entry);
            }

            public long getSize(String name) {
                JarEntry entry = agentJarFile.getJarEntry(name);
                return entry.getSize();
            }
        };
    }

    private static JarFile getAgentJarFile() {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        return AgentJarHelper.getAgentJarFile(agentJarUrl);
    }

    private static JarFile getAgentJarFile(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return new JarFile(AgentJarHelper.getAgentJarFileName(agentJarUrl));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getAgentJarFileName(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return URLDecoder.decode(agentJarUrl.getFile().replace("+", "%2B"), "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getAgentJarFileName() {
        URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
        return AgentJarHelper.getAgentJarFileName(agentJarUrl);
    }

    public static String getBuildDate() {
        return AgentJarHelper.getAgentJarAttribute(BUILT_DATE_ATTRIBUTE);
    }

    public static String getAgentJarAttribute(String name) {
        JarFile jarFile = AgentJarHelper.getAgentJarFile();
        if (jarFile == null) {
            return null;
        }
        try {
            return jarFile.getManifest().getMainAttributes().getValue(name);
        }
        catch (IOException e) {
            return null;
        }
    }
}

