/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import java.sql.ResultSetMetaData;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDatabaseStatementParser
implements DatabaseStatementParser {
    private final DatabaseStatementParser databaseStatementParser;
    private volatile Cache<String, ParsedDatabaseStatement> statements;

    public CachingDatabaseStatementParser(DatabaseStatementParser databaseStatementParser) {
        this.databaseStatementParser = databaseStatementParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<String, ParsedDatabaseStatement> getOrCreateCache() {
        if (null == this.statements) {
            CachingDatabaseStatementParser cachingDatabaseStatementParser = this;
            synchronized (cachingDatabaseStatementParser) {
                if (null == this.statements) {
                    this.statements = CacheBuilder.newBuilder().maximumSize(100L).build();
                }
            }
        }
        return this.statements;
    }

    @Override
    public ParsedDatabaseStatement getParsedDatabaseStatement(final String statement, final ResultSetMetaData resultSetMetaData) {
        Throwable toLog = null;
        try {
            return this.getOrCreateCache().get(statement, new Callable<ParsedDatabaseStatement>(){

                @Override
                public ParsedDatabaseStatement call() throws Exception {
                    return CachingDatabaseStatementParser.this.databaseStatementParser.getParsedDatabaseStatement(statement, resultSetMetaData);
                }
            });
        }
        catch (ExecutionException ee) {
            toLog = ee;
            if (ee.getCause() != null) {
                toLog = ee.getCause();
            }
        }
        catch (Exception ex) {
            toLog = ex;
        }
        Agent.LOG.log(Level.FINEST, "In cache.get() or its loader:", toLog);
        return UNPARSEABLE_STATEMENT;
    }
}

