/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deadlock;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.errors.DeadlockTraceError;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.service.ServiceFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadLockDetector {
    private static final int MAX_THREAD_DEPTH = 300;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    protected void detectDeadlockedThreads() {
        ThreadInfo[] threadInfos = this.getDeadlockedThreadInfos();
        if (threadInfos.length > 0) {
            Agent.LOG.info(MessageFormat.format("Detected {0} deadlocked threads", threadInfos.length));
            if (Agent.isDebugEnabled()) {
                boolean harvestThreadLocked = false;
                for (ThreadInfo threadInfo : threadInfos) {
                    if (!threadInfo.getThreadName().equals("New Relic Harvest Service")) continue;
                    harvestThreadLocked = true;
                }
                if (harvestThreadLocked) {
                    Agent.LOG.severe("A harvest thread deadlock condition was detected");
                    return;
                }
            }
            this.reportDeadlocks(Arrays.asList(threadInfos));
        }
    }

    ThreadInfo[] getDeadlockedThreadInfos() {
        long[] deadlockedThreadIds = this.findDeadlockedThreads();
        if (deadlockedThreadIds == null) {
            return new ThreadInfo[0];
        }
        return this.threadMXBean.getThreadInfo(deadlockedThreadIds, 300);
    }

    protected ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    protected long[] findDeadlockedThreads() {
        try {
            return this.getThreadMXBean().findDeadlockedThreads();
        }
        catch (UnsupportedOperationException e) {
            return this.getThreadMXBean().findMonitorDeadlockedThreads();
        }
    }

    private void reportDeadlocks(List<ThreadInfo> deadThreads) {
        TracedError[] tracedErrors = this.getTracedErrors(deadThreads);
        this.getErrorService().reportErrors(tracedErrors);
    }

    private ErrorService getErrorService() {
        return ServiceFactory.getRPMService().getErrorService();
    }

    TracedError[] getTracedErrors(List<ThreadInfo> threadInfos) {
        HashMap<Long, ThreadInfo> idToThreads = new HashMap<Long, ThreadInfo>();
        for (ThreadInfo thread : threadInfos) {
            idToThreads.put(thread.getThreadId(), thread);
        }
        ArrayList<DeadlockTraceError> errors = new ArrayList<DeadlockTraceError>();
        HashSet<Long> skipIds = new HashSet<Long>();
        for (ThreadInfo thread : threadInfos) {
            if (skipIds.contains(thread.getThreadId())) continue;
            long otherId = thread.getLockOwnerId();
            skipIds.add(otherId);
            ThreadInfo otherThread = (ThreadInfo)idToThreads.get(otherId);
            HashMap<String, String> parameters = Maps.newHashMapWithExpectedSize(4);
            parameters.put("jvm.thread_name", thread.getThreadName());
            HashMap<String, StackTraceElement[]> stackTraces = new HashMap<String, StackTraceElement[]>();
            stackTraces.put(thread.getThreadName(), thread.getStackTrace());
            if (otherThread != null) {
                parameters.put("jvm.lock_thread_name", otherThread.getThreadName());
                stackTraces.put(otherThread.getThreadName(), otherThread.getStackTrace());
            }
            errors.add(new DeadlockTraceError(null, thread, stackTraces, parameters));
        }
        return errors.toArray(new TracedError[0]);
    }
}

